/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.ByteBuffer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.InBoundingBox;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EClass;

public class QueryBoundingBoxStackFrame
extends DatabaseReadingStackFrame
implements ObjectProvidingStackFrame {
    private EClass eClass;
    private SearchingRecordIterator typeRecordIterator;
    private Record record;
    private InBoundingBox inBoundingBox;

    public QueryBoundingBoxStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart queryPart, QueryContext reusable, InBoundingBox inBoundingBox) throws BimserverDatabaseException {
        super(reusable, queryObjectProvider, queryPart);
        this.eClass = eClass;
        this.inBoundingBox = inBoundingBox;
        String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
        if (reusable.getOidCounters() != null) {
            if (!reusable.getOidCounters().containsKey(eClass)) {
                return;
            }
            long startOid = (Long)reusable.getOidCounters().get(eClass);
            ByteBuffer tmp = ByteBuffer.allocate(12);
            tmp.putInt(reusable.getPid());
            tmp.putLong(startOid + 1L);
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), tmp.array(), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        } else {
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), BinUtils.intToByteArray((int)this.getReusable().getPid()), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        }
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.typeRecordIterator == null) {
            return true;
        }
        if (this.record == null) {
            this.currentObject = null;
            this.typeRecordIterator.close();
            return true;
        }
        this.currentObject = null;
        ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
        this.getQueryObjectProvider().incReads();
        ByteBuffer keyBuffer = ByteBuffer.wrap(this.record.getKey());
        int keyPid = keyBuffer.getInt();
        long keyOid = keyBuffer.getLong();
        int keyRid = -keyBuffer.getInt();
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.record.getValue());
        DatabaseSession.GetResult map = this.getMap(this.eClass, this.eClass, valueBuffer, keyPid, keyOid, keyRid);
        if (map == DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID) {
            nextKeyStart.position(0);
            nextKeyStart.putInt(this.getReusable().getPid());
            nextKeyStart.putLong(keyOid + 1L);
            this.record = this.typeRecordIterator.next(nextKeyStart.array());
        } else {
            this.record = this.typeRecordIterator.next();
        }
        if (this.currentObject != null) {
            if (this.currentObject.has("geometry")) {
                long geometryInfoId = (Long)this.currentObject.get("geometry");
                HashMapVirtualObject geometryInfo = this.getByOid(geometryInfoId);
                HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)geometryInfo.get("minBounds");
                HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)geometryInfo.get("maxBounds");
                float minX = ((Float)minBounds.eGet("x")).floatValue();
                float minY = ((Float)minBounds.eGet("y")).floatValue();
                float minZ = ((Float)minBounds.eGet("z")).floatValue();
                float maxX = ((Float)maxBounds.eGet("x")).floatValue();
                float maxY = ((Float)maxBounds.eGet("y")).floatValue();
                float maxZ = ((Float)maxBounds.eGet("z")).floatValue();
                if (!((double)minX > this.inBoundingBox.getX() && (double)minY > this.inBoundingBox.getY() && (double)minZ > this.inBoundingBox.getZ() && (double)maxX < this.inBoundingBox.getX() + this.inBoundingBox.getWidth() && (double)maxY < this.inBoundingBox.getY() + this.inBoundingBox.getHeight() && (double)maxZ < this.inBoundingBox.getZ() + this.inBoundingBox.getDepth())) {
                    this.currentObject = null;
                }
            } else {
                this.currentObject = null;
            }
        }
        this.processPossibleIncludes(this.eClass, (CanInclude)this.getQueryPart());
        return false;
    }

    @Override
    public HashMapVirtualObject getCurrentObject() {
        return this.currentObject;
    }
}

