/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryOidsAndTypesStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EClass;

public class QueryGuidsAndTypesStackFrame
extends StackFrame {
    private EClass eClass;
    private QueryObjectProvider queryObjectProvider;
    private Set<Long> oids;
    private QueryContext reusable;
    private QueryPart jsonQuery;
    private boolean converted;

    public QueryGuidsAndTypesStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart jsonQuery, QueryContext reusable, Set<String> guids) throws BimserverDatabaseException {
        this.queryObjectProvider = queryObjectProvider;
        this.eClass = eClass;
        this.jsonQuery = jsonQuery;
        this.reusable = reusable;
        this.oids = new HashSet<Long>();
        for (String guid : guids) {
            ObjectIdentifier oidOfGuid = this.getOidOfGuid(reusable.getPackageMetaData().getSchema().name(), guid, reusable.getPid(), reusable.getRid());
            if (oidOfGuid == null) continue;
            this.oids.add(oidOfGuid.getOid());
        }
        if (this.oids.isEmpty()) {
            this.converted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectIdentifier getOidOfGuid(String schema, String guid, int pid, int rid) throws BimserverDatabaseException {
        for (EClass eClass : this.reusable.getPackageMetaData().getAllSubClasses(this.reusable.getPackageMetaData().getEClass("IfcRoot"))) {
            try (SearchingRecordIterator recordIterator = this.queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), BinUtils.intToByteArray((int)pid), BinUtils.intToByteArray((int)pid), this.queryObjectProvider.getDatabaseSession());){
                Record record = recordIterator.next();
                while (record != null) {
                    this.queryObjectProvider.incReads();
                    ByteBuffer buffer = ByteBuffer.wrap(record.getKey());
                    int pidOfRecord = buffer.getInt();
                    long oid = buffer.getLong();
                    int ridOfRecord = -buffer.getInt();
                    if (ridOfRecord == rid && pid == pidOfRecord) {
                        ByteBuffer value = ByteBuffer.wrap(record.getValue());
                        value.position(value.position() + this.reusable.getPackageMetaData().getUnsettedLength(eClass));
                        if (value.capacity() > 1) {
                            int stringLength = value.getInt();
                            if (stringLength == -1) {
                                ObjectIdentifier objectIdentifier = null;
                                return objectIdentifier;
                            }
                            String s = BinUtils.readString((ByteBuffer)value, (int)stringLength);
                            if (s.equals(guid)) {
                                ObjectIdentifier objectIdentifier = new ObjectIdentifier(oid, this.queryObjectProvider.getDatabaseSession().getCid(eClass));
                                return objectIdentifier;
                            }
                        }
                    }
                    record = recordIterator.next();
                }
            }
        }
        return null;
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.converted) {
            return true;
        }
        this.converted = true;
        this.queryObjectProvider.push(new QueryOidsAndTypesStackFrame(this.queryObjectProvider, this.eClass, this.jsonQuery, this.reusable, new ArrayList<Long>(this.oids)));
        return false;
    }
}

