/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.FollowReferenceStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.shared.WrappedVirtualObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QueryIncludeStackFrame
extends DatabaseReadingStackFrame {
    private Set<Short> outputFilterCids;
    private Iterator<EReference> featureIterator;
    private Include include;
    private EReference feature;

    public QueryIncludeStackFrame(QueryObjectProvider queryObjectProvider, QueryContext queryContext, CanInclude previousInclude, Include include, HashMapVirtualObject currentObject, QueryPart queryPart) throws QueryException, BimserverDatabaseException {
        super(queryContext, queryObjectProvider, queryPart);
        this.include = include;
        this.currentObject = currentObject;
        List features = include.getFields();
        if (features == null || features.isEmpty()) {
            this.setDone(true);
            return;
        }
        this.featureIterator = features.iterator();
        if (include.getOutputTypes() != null) {
            this.outputFilterCids = new HashSet<Short>();
            for (EClass eClass : include.getOutputTypes()) {
                short cid = queryObjectProvider.getDatabaseSession().getCidOfEClass(eClass);
                this.outputFilterCids.add(cid);
            }
        }
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        this.feature = this.featureIterator.next();
        Object value = this.currentObject.eGet((EStructuralFeature)this.feature);
        if (value != null) {
            if (this.feature.isMany()) {
                List list = (List)value;
                for (Object r : list) {
                    if (!(r instanceof Long)) continue;
                    this.processReference((Long)r);
                }
            } else if (value instanceof Long) {
                long refOid = (Long)value;
                this.processReference(refOid);
            } else if (value instanceof WrappedVirtualObject) {
                // empty if block
            }
        }
        return !this.featureIterator.hasNext();
    }

    private void processReference(long refOid) {
        if ((this.outputFilterCids == null || this.outputFilterCids.contains((short)refOid)) && !this.getQueryObjectProvider().hasRead(refOid)) {
            this.getQueryObjectProvider().push(new FollowReferenceStackFrame(this.getQueryObjectProvider(), refOid, this.getReusable(), this.getQueryPart(), this.feature, this.include));
        }
    }
}

