/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.database.queries.StartFrame;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryException;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryObjectProvider
implements ObjectProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryObjectProvider.class);
    private DatabaseSession databaseSession;
    private BimServer bimServer;
    private final Set<Long> oidsRead = new HashSet<Long>();
    private Deque<StackFrame> stack;
    private long start = -1L;
    private long reads = 0L;
    private long stackFramesProcessed = 0L;
    private final Set<Long> goingToRead = new HashSet<Long>();
    private Query query;

    public QueryObjectProvider(DatabaseSession databaseSession, BimServer bimServer, Query query, Set<Long> roids, PackageMetaData packageMetaData) throws JsonParseException, JsonMappingException, IOException, QueryException {
        this.databaseSession = databaseSession;
        this.bimServer = bimServer;
        this.query = query;
        this.stack = new ArrayDeque<StackFrame>();
        this.stack.push(new StartFrame(this, roids));
        for (QueryPart queryPart : query.getQueryParts()) {
            if (!queryPart.hasOids()) continue;
            this.goingToRead.addAll(queryPart.getOids());
        }
    }

    public static QueryObjectProvider fromJsonNode(DatabaseSession databaseSession, BimServer bimServer, JsonNode fullQuery, Set<Long> roids, PackageMetaData packageMetaData) throws JsonParseException, JsonMappingException, IOException, QueryException {
        if (fullQuery instanceof ObjectNode) {
            JsonQueryObjectModelConverter converter = new JsonQueryObjectModelConverter(packageMetaData);
            Query query = converter.parseJson("query", (ObjectNode)fullQuery);
            return new QueryObjectProvider(databaseSession, bimServer, query, roids, packageMetaData);
        }
        throw new QueryException("Query root must be of type object");
    }

    public static QueryObjectProvider fromJsonString(DatabaseSession databaseSession, BimServer bimServer, String json, Set<Long> roids, PackageMetaData packageMetaData) throws JsonParseException, JsonMappingException, IOException, QueryException {
        return QueryObjectProvider.fromJsonNode(databaseSession, bimServer, (JsonNode)new ObjectMapper().readValue(json, ObjectNode.class), roids, packageMetaData);
    }

    public Query getQuery() {
        return this.query;
    }

    public HashMapVirtualObject next() throws BimserverDatabaseException {
        if (this.start == -1L) {
            this.start = System.nanoTime();
        }
        try {
            while (!this.stack.isEmpty()) {
                HashMapVirtualObject currentObject;
                if (this.stack.size() > 10000) {
                    this.dumpEndQuery();
                    throw new BimserverDatabaseException("Query stack size > 1000, probably a bug, please report");
                }
                StackFrame stackFrame = this.stack.peek();
                if (stackFrame.isDone()) {
                    this.stack.pop();
                    continue;
                }
                ++this.stackFramesProcessed;
                if (this.stackFramesProcessed > 10000000L) {
                    this.dumpEndQuery();
                    throw new BimserverDatabaseException("Too many stack frames processed, probably a bug, please report");
                }
                boolean done = stackFrame.process();
                stackFrame.setDone(done);
                if (!(stackFrame instanceof ObjectProvidingStackFrame) || (currentObject = ((ObjectProvidingStackFrame)((Object)stackFrame)).getCurrentObject()) == null || this.oidsRead.contains(currentObject.getOid())) continue;
                this.oidsRead.add(currentObject.getOid());
                return currentObject;
            }
        }
        catch (Exception e) {
            throw new BimserverDatabaseException((Throwable)e);
        }
        this.dumpEndQuery();
        return null;
    }

    private void dumpEndQuery() {
        StackFrame poll = this.stack.poll();
        if (poll != null) {
            LOGGER.info("Query dump");
            for (int i = 0; poll != null && i < 20; ++i) {
                LOGGER.info("\t" + poll.toString());
                poll = this.stack.poll();
            }
        }
        long end = System.nanoTime();
        LOGGER.info("Query, " + this.reads + " reads, " + this.stackFramesProcessed + " stack frames processed, " + this.oidsRead.size() + " objects read, " + (end - this.start) / 1000000L + "ms");
    }

    public void incReads() {
        ++this.reads;
    }

    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    public MetaDataManager getMetaDataManager() {
        return this.bimServer.getMetaDataManager();
    }

    public boolean hasRead(long oid) {
        return this.oidsRead.contains(oid);
    }

    public void push(StackFrame stackFrame) {
        if (!stackFrame.isDone()) {
            this.stack.push(stackFrame);
        }
    }

    public boolean hasReadOrIsGoingToRead(EClass eClass) {
        for (QueryPart queryPart : this.query.getQueryParts()) {
            if (queryPart.hasTypes()) {
                if (!queryPart.getTypes().contains(eClass) || queryPart.getGuids() != null || queryPart.getOids() != null || queryPart.getInBoundingBox() != null || queryPart.getProperties() != null) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean hasReadOrIsGoingToRead(Long oid) {
        if (this.oidsRead.contains(oid)) {
            return true;
        }
        return this.goingToRead.contains(oid);
    }

    public String toString() {
        return super.toString();
    }
}

