/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EClass;

public class QueryOidsAndTypesStackFrame
extends DatabaseReadingStackFrame
implements ObjectProvidingStackFrame {
    private EClass eClass;
    private SearchingRecordIterator typeRecordIterator;
    private Record record;
    private Iterator<Long> oidIterator;

    public QueryOidsAndTypesStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart queryPart, QueryContext reusable, List<Long> oids) throws BimserverLockConflictException, BimserverDatabaseException, QueryException {
        super(reusable, queryObjectProvider, queryPart);
        this.eClass = eClass;
        Collections.sort(oids);
        String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
        if (this.getReusable().getOidCounters() != null) {
            if (!this.getReusable().getOidCounters().containsKey(eClass)) {
                return;
            }
            long startOid = (Long)this.getReusable().getOidCounters().get(eClass) + 1L;
            this.oidIterator = oids.iterator();
            long firstOid = this.oidIterator.next();
            if (firstOid < startOid) {
                throw new QueryException("Querying oid " + firstOid + " which cannot be in this revision");
            }
            startOid = firstOid;
            ByteBuffer tmp = ByteBuffer.allocate(12);
            tmp.putInt(this.getReusable().getPid());
            tmp.putLong(startOid);
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), tmp.array(), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        } else {
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), BinUtils.intToByteArray((int)this.getReusable().getPid()), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        }
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.typeRecordIterator == null) {
            return true;
        }
        if (this.record == null) {
            this.currentObject = null;
            this.typeRecordIterator.close();
            return true;
        }
        this.currentObject = null;
        ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
        this.getQueryObjectProvider().incReads();
        ByteBuffer keyBuffer = ByteBuffer.wrap(this.record.getKey());
        int keyPid = keyBuffer.getInt();
        long keyOid = keyBuffer.getLong();
        int keyRid = -keyBuffer.getInt();
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.record.getValue());
        DatabaseSession.GetResult map = this.getMap(this.eClass, this.eClass, valueBuffer, keyPid, keyOid, keyRid);
        if (map == DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID) {
            if (this.oidIterator.hasNext()) {
                nextKeyStart.position(0);
                nextKeyStart.putInt(this.getReusable().getPid());
                nextKeyStart.putLong(this.oidIterator.next());
                this.record = this.typeRecordIterator.next(nextKeyStart.array());
            } else {
                this.record = null;
            }
        } else {
            this.record = this.typeRecordIterator.next();
        }
        this.processPossibleIncludes(this.eClass, (CanInclude)this.getQueryPart());
        if (this.record == null) {
            this.typeRecordIterator.close();
        }
        return this.record == null;
    }

    @Override
    public HashMapVirtualObject getCurrentObject() {
        return this.currentObject;
    }
}

