/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.queries.QueryBoundingBoxStackFrame;
import org.bimserver.database.queries.QueryGuidsAndTypesStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryOidsAndTypesStackFrame;
import org.bimserver.database.queries.QueryPropertiesAndTypesStackFrame;
import org.bimserver.database.queries.QueryTypeStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.database.queries.om.InBoundingBox;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.eclipse.emf.ecore.EClass;

public class QueryPartStackFrame
extends StackFrame {
    private Iterator<EClass> typeIterator;
    private QueryObjectProvider queryObjectProvider;
    private QueryContext reusable;
    private QueryPart partialQuery;
    private final Map<EClass, List<Long>> oids;
    private final Set<String> guids;
    private Map<String, Object> properties;
    private InBoundingBox inBoundingBox;

    public QueryPartStackFrame(QueryObjectProvider queryObjectProvider, QueryPart partialQuery, QueryContext reusable) throws BimserverDatabaseException, QueryException {
        this.queryObjectProvider = queryObjectProvider;
        this.partialQuery = partialQuery;
        this.reusable = reusable;
        if (partialQuery.hasOids()) {
            List oidsList = partialQuery.getOids();
            this.oids = new HashMap<EClass, List<Long>>();
            if (oidsList.size() == 0) {
                throw new QueryException("\"oids\" parameter of type array is of size 0");
            }
            for (int i = 0; i < oidsList.size(); ++i) {
                long oid = (Long)oidsList.get(i);
                EClass eClass = queryObjectProvider.getDatabaseSession().getEClassForOid(oid);
                List<Long> list = this.oids.get(eClass);
                if (list == null) {
                    list = new ArrayList<Long>();
                    this.oids.put(eClass, list);
                }
                list.add(oid);
            }
        } else {
            this.oids = null;
        }
        this.typeIterator = !partialQuery.hasTypes() ? (this.oids == null ? reusable.getOidCounters().keySet().iterator() : this.oids.keySet().iterator()) : partialQuery.getTypes().iterator();
        this.guids = this.partialQuery.getGuids() != null ? partialQuery.getGuids() : null;
        this.properties = partialQuery.getProperties();
        this.inBoundingBox = partialQuery.getInBoundingBox();
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.typeIterator == null) {
            return true;
        }
        if (this.typeIterator.hasNext()) {
            EClass eClass = this.typeIterator.next();
            if (this.oids != null) {
                this.queryObjectProvider.push(new QueryOidsAndTypesStackFrame(this.queryObjectProvider, eClass, this.partialQuery, this.reusable, this.oids.get(eClass)));
            } else if (this.guids != null) {
                this.queryObjectProvider.push(new QueryGuidsAndTypesStackFrame(this.queryObjectProvider, eClass, this.partialQuery, this.reusable, this.guids));
            } else if (this.properties != null) {
                this.queryObjectProvider.push(new QueryPropertiesAndTypesStackFrame(this.queryObjectProvider, eClass, this.partialQuery, this.reusable, this.properties));
            } else if (this.inBoundingBox != null) {
                this.queryObjectProvider.push(new QueryBoundingBoxStackFrame(this.queryObjectProvider, eClass, this.partialQuery, this.reusable, this.inBoundingBox));
            } else {
                this.queryObjectProvider.push(new QueryTypeStackFrame(this.queryObjectProvider, eClass, this.reusable, this.partialQuery));
            }
            return false;
        }
        return true;
    }
}

