/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.OldQuery;
import org.bimserver.database.queries.ConcreteRevisionStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;

public class RevisionStackFrame
extends StackFrame {
    private Revision currentRevision;
    private Map<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
    private Iterator<ConcreteRevision> concreteRevisionIterator;
    private QueryObjectProvider queryObjectProvider;

    public RevisionStackFrame(QueryObjectProvider queryObjectProvider, long roid) throws BimserverDatabaseException {
        this.queryObjectProvider = queryObjectProvider;
        this.currentRevision = (Revision)queryObjectProvider.getDatabaseSession().get(StorePackage.eINSTANCE.getRevision(), roid, (QueryInterface)OldQuery.getDefault());
        this.pidRoidMap.put(this.currentRevision.getProject().getId(), this.currentRevision.getOid());
        this.concreteRevisionIterator = this.currentRevision.getConcreteRevisions().iterator();
    }

    @Override
    public boolean process() {
        this.queryObjectProvider.push(new ConcreteRevisionStackFrame(this.queryObjectProvider, this.concreteRevisionIterator.next()));
        return !this.concreteRevisionIterator.hasNext();
    }
}

