/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import org.bimserver.BimServer;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.CheckoutDatabaseAction;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.longaction.LongDownloadOrCheckoutAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ActionState;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class LongCheckoutAction
extends LongDownloadOrCheckoutAction {
    private CheckoutDatabaseAction action;
    private DatabaseSession session;

    public LongCheckoutAction(BimServer bimServer, String username, String userUsername, DownloadParameters downloadParameters, Authorization authorization, AccessMethod accessMethod) {
        super(bimServer, username, userUsername, downloadParameters, accessMethod, authorization);
        this.setProgressTopic(bimServer.getNotificationsManager().createProgressTopic(SProgressTopicType.DOWNLOAD, "Download"));
    }

    @Override
    public void execute() {
        this.changeActionState(ActionState.STARTED, "Starting checkout", 0);
        try {
            this.executeAction(this.action, this.downloadParameters, this.session, true);
        }
        catch (Exception e) {
            if (e instanceof UserException) {
            } else {
                LOGGER.error("", (Throwable)e);
            }
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
            this.changeActionState(ActionState.FINISHED, "Checkout finished", 100);
        }
    }

    @Override
    public String getDescription() {
        return "Checkout";
    }

    @Override
    public void init(Thread thread) {
        super.init(thread);
        this.session = this.getBimServer().getDatabase().createSession();
        this.action = new CheckoutDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.getAuthorization(), this.downloadParameters.getRoid(), this.downloadParameters.getSerializerOid());
        this.action.addProgressListener(this);
    }
}

