/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.DownloadByGuidsDatabaseAction;
import org.bimserver.database.actions.DownloadByJsonQueryDatabaseAction;
import org.bimserver.database.actions.DownloadByNamesDatabaseAction;
import org.bimserver.database.actions.DownloadByNewJsonQueryDatabaseAction;
import org.bimserver.database.actions.DownloadByOidsDatabaseAction;
import org.bimserver.database.actions.DownloadByTypesDatabaseAction;
import org.bimserver.database.actions.DownloadCompareDatabaseAction;
import org.bimserver.database.actions.DownloadDatabaseAction;
import org.bimserver.database.actions.DownloadProjectsDatabaseAction;
import org.bimserver.database.actions.DownloadQueryDatabaseAction;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.longaction.LongDownloadOrCheckoutAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.ObjectIDMPluginConfiguration;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDMPlugin;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class LongDownloadAction
extends LongDownloadOrCheckoutAction
implements ProgressListener {
    private BimDatabaseAction<? extends IfcModelInterface> action;
    private DatabaseSession session;

    public LongDownloadAction(BimServer bimServer, String username, String userUsername, DownloadParameters downloadParameters, Authorization authorization, AccessMethod accessMethod) {
        super(bimServer, username, userUsername, downloadParameters, accessMethod, authorization);
        this.setProgressTopic(bimServer.getNotificationsManager().createProgressTopic(SProgressTopicType.DOWNLOAD, "Download"));
    }

    @Override
    public void execute() {
        this.changeActionState(ActionState.STARTED, "Starting download", 0);
        try {
            this.executeAction(this.action, this.downloadParameters, this.session, false);
        }
        catch (UserException e) {
            this.error((Exception)((Object)e));
        }
        catch (Exception e) {
            this.error(e);
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
            if (this.getErrors().size() == 0) {
                this.changeActionState(ActionState.STARTED, "Done preparing", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Thread thread) {
        super.init(thread);
        if (this.getBimServer().getServerSettingsCache().getServerSettings().getCacheOutputFiles().booleanValue() && this.getBimServer().getDiskCacheManager().contains(this.downloadParameters)) {
            return;
        }
        ObjectIDM objectIDM = null;
        if (this.downloadParameters.getUseObjectIDM()) {
            this.session = this.getBimServer().getDatabase().createSession();
            try {
                ObjectIDMPlugin objectIDMPlugin;
                ObjectIDMPluginConfiguration objectIdm;
                SerializerPluginConfiguration serializerPluginConfiguration = (SerializerPluginConfiguration)this.session.get(StorePackage.eINSTANCE.getSerializerPluginConfiguration(), this.downloadParameters.getSerializerOid(), (QueryInterface)OldQuery.getDefault());
                if (serializerPluginConfiguration != null && (objectIdm = serializerPluginConfiguration.getObjectIDM()) != null && (objectIDMPlugin = this.getBimServer().getPluginManager().getObjectIDMByName(objectIdm.getPluginDescriptor().getPluginClassName(), true)) != null) {
                    objectIDM = objectIDMPlugin.getObjectIDM(new PluginConfiguration());
                }
            }
            catch (BimserverDatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                this.session.close();
            }
        }
        this.session = this.getBimServer().getDatabase().createSession();
        switch (this.downloadParameters.getDownloadType()) {
            case DOWNLOAD_REVISION: {
                this.action = new DownloadDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoid(), this.downloadParameters.getIgnoreUoid(), this.downloadParameters.getSerializerOid(), this.getAuthorization(), objectIDM);
                break;
            }
            case DOWNLOAD_BY_OIDS: {
                this.action = new DownloadByOidsDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getOids(), this.downloadParameters.getSerializerOid(), this.getAuthorization(), objectIDM, this.downloadParameters.getDeep());
                break;
            }
            case DOWNLOAD_BY_GUIDS: {
                this.action = new DownloadByGuidsDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getGuids(), this.downloadParameters.getSerializerOid(), this.getAuthorization(), objectIDM, this.downloadParameters.getDeep());
                break;
            }
            case DOWNLOAD_BY_NAMES: {
                this.action = new DownloadByNamesDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getNames(), this.downloadParameters.getSerializerOid(), this.getAuthorization(), objectIDM, this.downloadParameters.getDeep());
                break;
            }
            case DOWNLOAD_OF_TYPE: {
                this.action = new DownloadByTypesDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getSchema(), this.downloadParameters.getClassNames(), this.downloadParameters.getSerializerOid(), this.downloadParameters.isIncludeAllSubtypes(), this.downloadParameters.getUseObjectIDM(), this.getAuthorization(), objectIDM, this.downloadParameters.getDeep());
                break;
            }
            case DOWNLOAD_JSON_QUERY: {
                this.action = new DownloadByJsonQueryDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getJsonQuery(), this.downloadParameters.getSerializerOid(), this.getAuthorization());
                break;
            }
            case DOWNLOAD_BY_NEW_JSON_QUERY: {
                this.action = new DownloadByNewJsonQueryDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getJsonQuery(), this.downloadParameters.getSerializerOid(), this.getAuthorization());
                break;
            }
            case DOWNLOAD_PROJECTS: {
                this.action = new DownloadProjectsDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getSerializerOid(), this.getAuthorization(), objectIDM);
                break;
            }
            case DOWNLOAD_COMPARE: {
                this.action = new DownloadCompareDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoids(), this.downloadParameters.getModelCompareIdentifier(), this.downloadParameters.getCompareType(), this.getAuthorization(), objectIDM);
                break;
            }
            case DOWNLOAD_QUERY: {
                this.action = new DownloadQueryDatabaseAction(this.getBimServer(), this.session, this.accessMethod, this.downloadParameters.getRoid(), this.downloadParameters.getQeid(), this.downloadParameters.getSerializerOid(), this.downloadParameters.getCode(), this.getAuthorization(), objectIDM);
            }
        }
        this.action.addProgressListener(this);
    }

    @Override
    public String getDescription() {
        return "Download";
    }

    @Override
    protected void done() {
        super.done();
        this.action = null;
    }
}

