/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.QueryInterface;
import org.bimserver.exceptions.NoSerializerFoundException;
import org.bimserver.interfaces.objects.SCheckoutResult;
import org.bimserver.longaction.CachingDataHandler;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongDownloadAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.MessagingSerializerPluginConfiguration;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.Reporter;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.serializers.CacheStoringEmfSerializerDataSource;
import org.bimserver.plugins.serializers.EmfSerializerDataSource;
import org.bimserver.plugins.serializers.MessagingSerializer;
import org.bimserver.plugins.serializers.RemovableFileOutputStream;
import org.bimserver.plugins.serializers.Serializer;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongDownloadOrCheckoutAction
extends LongAction<DownloadParameters>
implements Reporter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LongDownloadAction.class);
    protected final AccessMethod accessMethod;
    protected final DownloadParameters downloadParameters;
    protected SCheckoutResult checkoutResult;
    protected MessagingSerializer messagingSerializer;

    protected LongDownloadOrCheckoutAction(BimServer bimServer, String username, String userUsername, DownloadParameters downloadParameters, AccessMethod accessMethod, Authorization authorization) {
        super(bimServer, username, userUsername, authorization);
        this.accessMethod = accessMethod;
        this.downloadParameters = downloadParameters;
    }

    public SCheckoutResult getCheckoutResult() {
        return this.checkoutResult;
    }

    protected SCheckoutResult convertModelToCheckoutResult(Project project, String username, IfcModelInterface model, RenderEnginePlugin renderEnginePlugin, DownloadParameters downloadParameters) throws UserException, NoSerializerFoundException {
        SCheckoutResult checkoutResult = new SCheckoutResult();
        if (model.isValid()) {
            checkoutResult.setProjectName(project.getName());
            checkoutResult.setRevisionNr(Integer.valueOf(model.getModelMetaData().getRevisionId()));
            try {
                Serializer serializer = this.getBimServer().getSerializerFactory().create(project, username, model, renderEnginePlugin, downloadParameters);
                if (serializer == null) {
                    throw new UserException("Error, no serializer found " + downloadParameters.getSerializerOid());
                }
                if (this.getBimServer().getServerSettingsCache().getServerSettings().getCacheOutputFiles().booleanValue() && serializer.allowCaching()) {
                    if (this.getBimServer().getDiskCacheManager().contains(downloadParameters)) {
                        checkoutResult.setFile((DataHandler)new CachingDataHandler(this.getBimServer().getDiskCacheManager(), downloadParameters));
                    } else {
                        checkoutResult.setFile(new DataHandler((DataSource)new CacheStoringEmfSerializerDataSource(serializer, (RemovableFileOutputStream)this.getBimServer().getDiskCacheManager().startCaching(downloadParameters))));
                    }
                } else {
                    checkoutResult.setFile(new DataHandler((DataSource)new EmfSerializerDataSource(serializer)));
                }
            }
            catch (SerializerException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return checkoutResult;
    }

    public MessagingSerializer getMessagingSerializer() {
        return this.messagingSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAction(BimDatabaseAction<? extends IfcModelInterface> action, DownloadParameters downloadParameters, DatabaseSession session, boolean commit) throws BimserverDatabaseException, UserException, NoSerializerFoundException, ServerException {
        block17: {
            try {
                if (action == null) {
                    this.checkoutResult = new SCheckoutResult();
                    this.checkoutResult.setFile((DataHandler)new CachingDataHandler(this.getBimServer().getDiskCacheManager(), downloadParameters));
                    break block17;
                }
                Revision revision = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), (long)downloadParameters.getRoid(), (QueryInterface)OldQuery.getDefault());
                if (revision == null) {
                    throw new UserException("Revision with roid " + downloadParameters.getRoid() + " not found");
                }
                revision.getProject().getGeoTag().load();
                IfcModelInterface ifcModel = session.executeAndCommitAction(action);
                RenderEnginePlugin renderEnginePlugin = null;
                try (DatabaseSession newSession = this.getBimServer().getDatabase().createSession();){
                    PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)newSession.get(StorePackage.eINSTANCE.getPluginConfiguration(), downloadParameters.getSerializerOid(), (QueryInterface)OldQuery.getDefault());
                    if (serializerPluginConfiguration != null) {
                        if (serializerPluginConfiguration instanceof SerializerPluginConfiguration) {
                            RenderEnginePluginConfiguration renderEngine = ((SerializerPluginConfiguration)serializerPluginConfiguration).getRenderEngine();
                            if (renderEngine != null) {
                                renderEnginePlugin = this.getBimServer().getPluginManager().getRenderEnginePlugin(renderEngine.getPluginDescriptor().getPluginClassName(), true);
                            }
                            this.checkoutResult = this.convertModelToCheckoutResult(revision.getProject(), this.getUserName(), ifcModel, renderEnginePlugin, downloadParameters);
                        } else if (serializerPluginConfiguration instanceof MessagingSerializerPluginConfiguration) {
                            try {
                                this.messagingSerializer = this.getBimServer().getSerializerFactory().createMessagingSerializer(this.getUserName(), ifcModel, downloadParameters);
                            }
                            catch (SerializerException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            finally {
                this.done();
            }
        }
    }
}

