/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.bimserver.BimServer;
import org.bimserver.cache.DownloadDescriptor;
import org.bimserver.cache.NewDiskCacheOutputStream;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.interfaces.objects.SCheckoutResult;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.MessagingStreamingDataSource;
import org.bimserver.longaction.StreamingDownloadKey;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.CacheStoringStreamingSerializerDataSource;
import org.bimserver.plugins.serializers.DoneListener;
import org.bimserver.plugins.serializers.MessagingStreamingSerializer;
import org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.RemovableFileOutputStream;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.StreamingSerializer;
import org.bimserver.plugins.serializers.StreamingSerializerDataSource;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.plugins.serializers.Writer;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongStreamingDownloadAction
extends LongAction<StreamingDownloadKey> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongStreamingDownloadAction.class);
    private Long serializerOid;
    private String jsonQuery;
    private Set<Long> roids;
    private StreamingSerializer serializer;
    private MessagingStreamingSerializer messagingStreamingSerializer;
    private String filename;
    private SCheckoutResult checkoutResult = new SCheckoutResult();
    private DownloadDescriptor downloadDescriptor;

    public LongStreamingDownloadAction(BimServer bimServer, String username, String userUsername, Authorization authorization, Long serializerOid, String jsonQuery, Set<Long> roids) {
        super(bimServer, username, userUsername, authorization);
        this.serializerOid = serializerOid;
        this.jsonQuery = jsonQuery;
        this.roids = roids;
        this.setProgressTopic(bimServer.getNotificationsManager().createProgressTopic(SProgressTopicType.DOWNLOAD, "Download"));
    }

    @Override
    public String getDescription() {
        return "description";
    }

    @Override
    public void execute() {
        DatabaseSession databaseSession = this.getBimServer().getDatabase().createSession();
        try {
            PackageMetaData packageMetaData = null;
            ProjectInfo projectInfo = new ProjectInfo();
            StringBuilder filename = new StringBuilder();
            Iterator<Long> iterator = this.roids.iterator();
            if (iterator.hasNext()) {
                Long roid = iterator.next();
                Revision revision = (Revision)databaseSession.get(roid, OldQuery.getDefault());
                ConcreteRevision concreteRevision = (ConcreteRevision)revision.getConcreteRevisions().get(0);
                projectInfo.setMinBounds(this.getBimServer().getSConverter().convertToSObject(concreteRevision.getMinBounds()));
                projectInfo.setMaxBounds(this.getBimServer().getSConverter().convertToSObject(concreteRevision.getMaxBounds()));
                projectInfo.setName("" + this.roids.iterator().next());
                packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
                filename.append(revision.getProject().getName());
            }
            this.filename = filename.toString();
            PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)databaseSession.get(this.serializerOid, OldQuery.getDefault());
            if (serializerPluginConfiguration == null) {
                LOGGER.info("No serializer config found");
            } else {
                Plugin plugin = this.getBimServer().getPluginManager().getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
                JsonQueryObjectModelConverter converter = new JsonQueryObjectModelConverter(packageMetaData);
                ObjectNode queryObject = (ObjectNode)new ObjectMapper().readValue(this.jsonQuery, ObjectNode.class);
                Query query = converter.parseJson("query", queryObject);
                this.downloadDescriptor = new DownloadDescriptor(this.roids, query, this.serializerOid, this.filename);
                if (this.getBimServer().getNewDiskCacheManager().contains(this.downloadDescriptor)) {
                    DataSource dataSource = this.getBimServer().getNewDiskCacheManager().get(this.downloadDescriptor);
                    this.checkoutResult.setFile(new DataHandler(dataSource));
                    this.changeActionState(ActionState.STARTED, "Done preparing", -1);
                } else {
                    QueryObjectProvider queryObjectProvider = new QueryObjectProvider(databaseSession, this.getBimServer(), query, this.roids, packageMetaData);
                    if (plugin instanceof MessagingStreamingSerializerPlugin) {
                        MessagingStreamingSerializerPlugin serializerPlugin = (MessagingStreamingSerializerPlugin)plugin;
                        this.messagingStreamingSerializer = serializerPlugin.createSerializer(null);
                        this.messagingStreamingSerializer.init((ObjectProvider)queryObjectProvider, projectInfo, (PluginManagerInterface)this.getBimServer().getPluginManager(), packageMetaData);
                        this.changeActionState(ActionState.STARTED, "Done preparing", -1);
                    } else if (plugin instanceof StreamingSerializerPlugin) {
                        StreamingSerializerPlugin streamingSerializerPlugin = (StreamingSerializerPlugin)plugin;
                        this.serializer = streamingSerializerPlugin.createSerializer(null);
                        this.serializer.init((ObjectProvider)queryObjectProvider, projectInfo, null, (PluginManagerInterface)this.getBimServer().getPluginManager(), packageMetaData);
                        this.changeActionState(ActionState.STARTED, "Done preparing", -1);
                    } else {
                        LOGGER.error("Unimplemented " + plugin);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public SCheckoutResult getCheckoutResult() throws SerializerException {
        if (this.checkoutResult.getFile() != null) {
            return this.checkoutResult;
        }
        if (this.serializer == null) {
            if (this.messagingStreamingSerializer == null) {
                throw new SerializerException("No serializer");
            }
            MessagingStreamingDataSource dataSource = new MessagingStreamingDataSource(this.messagingStreamingSerializer);
            this.checkoutResult.setFile(new DataHandler((DataSource)dataSource));
        } else if (this.getBimServer().getNewDiskCacheManager().isEnabled()) {
            NewDiskCacheOutputStream diskCacheOutputStream = this.getBimServer().getNewDiskCacheManager().startCaching(this.downloadDescriptor);
            CacheStoringStreamingSerializerDataSource cacheStoringEmfSerializerDataSource = new CacheStoringStreamingSerializerDataSource(this.serializer, (RemovableFileOutputStream)diskCacheOutputStream, new DoneListener(){

                public void done() {
                    LongStreamingDownloadAction.this.changeActionState(ActionState.FINISHED, "Done", 100);
                }
            });
            this.checkoutResult.setFile(new DataHandler((DataSource)cacheStoringEmfSerializerDataSource));
        } else {
            StreamingSerializerDataSource streamingSerializerDataSource = new StreamingSerializerDataSource(this.filename, this.serializer, new DoneListener(){

                public void done() {
                    LongStreamingDownloadAction.this.changeActionState(ActionState.FINISHED, "Done", 100);
                }
            });
            this.checkoutResult.setFile(new DataHandler((DataSource)streamingSerializerDataSource));
        }
        return this.checkoutResult;
    }

    public Writer getMessagingStreamingSerializer() {
        return this.messagingStreamingSerializer;
    }
}

