/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.mail;

import com.sun.mail.smtp.SMTPSSLTransport;
import com.sun.mail.smtp.SMTPTransport;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.bimserver.BimServer;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.SmtpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailMessage.class);
    private BimServer bimServer;
    private String subject;
    private InternetAddress from;
    private Message.RecipientType to;
    private InternetAddress[] addressTo;
    private String body;
    private String contentType;

    public EmailMessage(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public void send() throws MessagingException {
        Properties props = new Properties();
        ServerSettings serverSettings = this.bimServer.getServerSettingsCache().getServerSettings();
        props.put("mail.smtp.localhost", "bimserver.org");
        String smtpProps = serverSettings.getSmtpProtocol() == SmtpProtocol.SMTPS ? "mail.smtps.port" : "mail.smtp.port";
        props.put(smtpProps, (Object)serverSettings.getSmtpPort());
        if (serverSettings.getSmtpProtocol() == SmtpProtocol.STARTTLS) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        Session mailSession = Session.getDefaultInstance((Properties)props);
        SMTPTransport transport = null;
        try {
            if (serverSettings.getSmtpProtocol() == SmtpProtocol.SMTP) {
                transport = new SMTPTransport(mailSession, new URLName(serverSettings.getSmtpServer()));
            } else if (serverSettings.getSmtpProtocol() == SmtpProtocol.SMTPS) {
                transport = new SMTPSSLTransport(mailSession, new URLName(serverSettings.getSmtpServer()));
            } else if (serverSettings.getSmtpProtocol() == SmtpProtocol.STARTTLS) {
                transport = new SMTPSSLTransport(mailSession, new URLName(serverSettings.getSmtpServer()));
            } else {
                throw new RuntimeException("Unimplemented SMTP protocol: " + serverSettings.getSmtpProtocol());
            }
            transport.connect(serverSettings.getSmtpServer(), serverSettings.getSmtpUsername(), serverSettings.getSmtpPassword());
            MimeMessage message = new MimeMessage(mailSession);
            message.setSubject(this.subject);
            message.setRecipients(this.to, (Address[])this.addressTo);
            message.setContent((Object)this.body, this.contentType);
            message.setFrom((Address)this.from);
            transport.sendMessage((Message)message, (Address[])this.addressTo);
        }
        catch (MessagingException e) {
            LOGGER.error("Error sending email " + this.body + " " + e.getMessage());
        }
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String body, String contentType) {
        this.body = body;
        this.contentType = contentType;
    }

    public void setRecipients(Message.RecipientType to, InternetAddress[] addressTo) {
        this.to = to;
        this.addressTo = addressTo;
    }

    public void setFrom(InternetAddress from) {
        this.from = from;
    }
}

