/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.mail;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.bimserver.BimServer;
import org.bimserver.mail.EmailMessage;

public class MailSystem {
    private final BimServer bimServer;

    public MailSystem(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public static boolean isValidEmailAddress(String aEmailAddress) {
        if (aEmailAddress == null) {
            return false;
        }
        try {
            new InternetAddress(aEmailAddress);
            if (!MailSystem.hasNameAndDomain(aEmailAddress)) {
                return false;
            }
        }
        catch (AddressException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasNameAndDomain(String aEmailAddress) {
        String[] tokens = aEmailAddress.split("@");
        return tokens.length == 2 && !tokens[0].isEmpty() && !tokens[1].isEmpty();
    }

    public EmailMessage createMessage() {
        return new EmailMessage(this.bimServer);
    }
}

