/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.merging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.OidProvider;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.IfcModel;
import org.bimserver.ifc.TracingGarbageCollector;
import org.bimserver.models.ifc2x3tc1.IfcGloballyUniqueId;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.shared.IncrementingOidProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RevisionMerger {
    private IfcModelInterface oldModel;
    private IfcModelInterface newModel;
    private IfcModel resultModel;

    public RevisionMerger(IfcModelInterface oldModel, IfcModelInterface newModel) {
        this.oldModel = oldModel;
        this.newModel = newModel;
        this.resultModel = new BasicIfcModel(null, null, (int)oldModel.size());
    }

    public IfcModel merge() throws IfcModelInterfaceException {
        for (IdEObject idEObject : this.oldModel.getValues()) {
            this.copy(this.resultModel, idEObject, false);
        }
        this.resultModel.indexGuids();
        this.newModel.fixOids((OidProvider)new IncrementingOidProvider(this.resultModel.getHighestOid() + 1L));
        this.copyAttributesGuidObjectsAndAddNewObjects();
        this.updateReferences();
        this.fixExplicitNullReferences();
        this.fixNonGuidObjects();
        TracingGarbageCollector tracingGarbageCollector = new TracingGarbageCollector(this.resultModel);
        HashSet<IdEObject> rootObjects = new HashSet<IdEObject>();
        for (IdEObject idEObject : this.resultModel.getValues()) {
            if (!(idEObject instanceof IfcProject)) continue;
            rootObjects.add(idEObject);
        }
        tracingGarbageCollector.mark(rootObjects);
        tracingGarbageCollector.sweep();
        return this.resultModel;
    }

    public void cleanupUnmodified() {
        Iterator iterator = this.resultModel.keySet().iterator();
        while (iterator.hasNext()) {
            Long oid = (Long)iterator.next();
            IdEObject idEObject = this.resultModel.get(oid.longValue());
            IdEObject originalObject = this.oldModel.get(oid.longValue());
            if (originalObject == null) continue;
            boolean objectChanged = false;
            for (EAttribute eAttribute : idEObject.eClass().getEAllAttributes()) {
                Object value = idEObject.eGet((EStructuralFeature)eAttribute);
                Object originalValue = originalObject.eGet((EStructuralFeature)eAttribute);
                if (value == null && originalValue != null || value != null && originalValue == null) {
                    objectChanged = true;
                    continue;
                }
                if (value == null && originalValue == null || value.equals(originalValue)) continue;
                objectChanged = true;
            }
            if (!objectChanged) {
                for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                    if (eReference.isMany()) {
                        List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                        List originalList = (List)originalObject.eGet((EStructuralFeature)eReference);
                        if (list.size() != originalList.size()) {
                            objectChanged = true;
                            continue;
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            IdEObject referencedObject = (IdEObject)list.get(i);
                            IdEObject originalReferencedObject = (IdEObject)originalList.get(i);
                            if (referencedObject == null && originalReferencedObject != null || referencedObject != null && originalReferencedObject == null) {
                                objectChanged = true;
                                continue;
                            }
                            if (referencedObject == null && originalReferencedObject == null || referencedObject.getOid() == originalReferencedObject.getOid()) continue;
                            objectChanged = true;
                        }
                        continue;
                    }
                    IdEObject referencedObject = (IdEObject)idEObject.eGet((EStructuralFeature)eReference);
                    IdEObject originalReferencedObject = (IdEObject)originalObject.eGet((EStructuralFeature)eReference);
                    if (referencedObject == null && originalReferencedObject != null || referencedObject != null && originalReferencedObject == null) {
                        objectChanged = true;
                        continue;
                    }
                    if (referencedObject == null && originalReferencedObject == null || referencedObject.getOid() == originalReferencedObject.getOid()) continue;
                    objectChanged = true;
                }
            }
            if (objectChanged) continue;
            iterator.remove();
        }
    }

    private void fixNonGuidObjects() throws IfcModelInterfaceException {
        HashSet<List> clearedLists = new HashSet<List>();
        for (IdEObject idEObject : this.newModel.getValues()) {
            if (!(idEObject instanceof IfcRoot)) continue;
            String guid = ((IfcRoot)idEObject).getGlobalId();
            for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                Object referencedObject = idEObject.eGet((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    List list = (List)referencedObject;
                    List newList = (List)this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference);
                    boolean listIsCleared = false;
                    for (Object o : list) {
                        IdEObject referencedIDEObject;
                        if (o instanceof IfcRoot || o instanceof IfcGloballyUniqueId) continue;
                        if (!listIsCleared) {
                            newList.clear();
                            listIsCleared = true;
                        }
                        if (this.resultModel.contains((referencedIDEObject = (IdEObject)o).getOid())) {
                            newList.add(this.resultModel.get(referencedIDEObject.getOid()));
                            continue;
                        }
                        IdEObject smartCopy = this.copy(this.resultModel, referencedIDEObject, true);
                        newList.add(smartCopy);
                    }
                    continue;
                }
                if (referencedObject == null) {
                    if (this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference) != null && eReference.getEOpposite() != null) {
                        IdEObject x = (IdEObject)this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference);
                        if (eReference.getEOpposite().isMany()) {
                            List l = (List)x.eGet((EStructuralFeature)eReference.getEOpposite());
                            if (!clearedLists.contains(l)) {
                                clearedLists.add(l);
                                l.clear();
                            }
                        } else {
                            x.eSet((EStructuralFeature)eReference.getEOpposite(), null);
                        }
                    }
                    this.resultModel.getByGuid(guid).eSet((EStructuralFeature)eReference, null);
                    continue;
                }
                if (referencedObject instanceof IfcRoot || referencedObject instanceof IfcGloballyUniqueId) continue;
                IdEObject referencedIDEObject = (IdEObject)referencedObject;
                if (this.resultModel.contains(referencedIDEObject.getOid())) {
                    if (this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference) != null && eReference.getEOpposite() != null) {
                        IdEObject x = (IdEObject)this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference);
                        if (eReference.getEOpposite().isMany()) {
                            List l = (List)x.eGet((EStructuralFeature)eReference.getEOpposite());
                            if (!clearedLists.contains(l)) {
                                clearedLists.add(l);
                                l.clear();
                            }
                        } else {
                            x.eSet((EStructuralFeature)eReference.getEOpposite(), null);
                        }
                    }
                    this.resultModel.getByGuid(guid).eSet((EStructuralFeature)eReference, (Object)this.resultModel.get(referencedIDEObject.getOid()));
                    continue;
                }
                IdEObject smartCopy = this.copy(this.resultModel, referencedIDEObject, true);
                if (this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference) != null && eReference.getEOpposite() != null) {
                    IdEObject re = (IdEObject)this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference);
                    if (eReference.getEOpposite().isMany()) {
                        List l = (List)re.eGet((EStructuralFeature)eReference.getEOpposite());
                        if (!clearedLists.contains(l)) {
                            clearedLists.add(l);
                            l.clear();
                        }
                    } else {
                        re.eSet((EStructuralFeature)eReference.getEOpposite(), null);
                    }
                }
                this.resultModel.getByGuid(guid).eSet((EStructuralFeature)eReference, (Object)smartCopy);
            }
        }
    }

    private IdEObject copy(IfcModel target, IdEObject idEObject, boolean limitToNonGuids) throws IfcModelInterfaceException {
        if (target.contains(idEObject.getOid())) {
            return target.get(idEObject.getOid());
        }
        IdEObject newObject = (IdEObject)idEObject.eClass().getEPackage().getEFactoryInstance().create(idEObject.eClass());
        ((IdEObjectImpl)newObject).setOid(idEObject.getOid());
        if (newObject.getOid() != -1L) {
            target.add(newObject.getOid(), newObject);
        }
        for (EAttribute eAttribute : newObject.eClass().getEAllAttributes()) {
            newObject.eSet((EStructuralFeature)eAttribute, idEObject.eGet((EStructuralFeature)eAttribute));
        }
        for (EReference eReference : newObject.eClass().getEAllReferences()) {
            Object referencedObject = idEObject.eGet((EStructuralFeature)eReference);
            if (referencedObject instanceof IdEObject) {
                IdEObject refEObject = (IdEObject)referencedObject;
                if (limitToNonGuids && (referencedObject instanceof IfcRoot || referencedObject instanceof IfcGloballyUniqueId)) continue;
                newObject.eSet((EStructuralFeature)eReference, (Object)this.copy(target, refEObject, limitToNonGuids));
                continue;
            }
            if (!(referencedObject instanceof List)) continue;
            List list = (List)referencedObject;
            List newList = (List)newObject.eGet((EStructuralFeature)eReference);
            for (Object o : list) {
                IdEObject listObject;
                IdEObject smartCopy;
                if (limitToNonGuids && (o instanceof IfcRoot || o instanceof IfcGloballyUniqueId) || newList.contains(smartCopy = this.copy(target, listObject = (IdEObject)o, limitToNonGuids))) continue;
                newList.add(smartCopy);
            }
        }
        return newObject;
    }

    private void fixExplicitNullReferences() {
        for (IdEObject idEObject : this.newModel.getValues()) {
            if (!(idEObject instanceof IfcRoot)) continue;
            String guid = ((IfcRoot)idEObject).getGlobalId();
            for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                String oldGuid;
                Object eGet;
                if (eReference.isMany()) {
                    List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                    List oldList = (List)this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference);
                    HashSet<String> guidsToRemove = new HashSet<String>();
                    for (Object o : oldList) {
                        String referredGuid;
                        if (!(o instanceof IfcRoot) || !this.newModel.containsGuid(referredGuid = ((IfcRoot)o).getGlobalId())) continue;
                        boolean found = false;
                        for (Object q : list) {
                            String qGuid;
                            if (!(q instanceof IfcRoot) || !(qGuid = ((IfcRoot)q).getGlobalId()).equals(referredGuid)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        guidsToRemove.add(referredGuid);
                    }
                    if (guidsToRemove.isEmpty()) continue;
                    oldList.removeAll(guidsToRemove);
                    continue;
                }
                if (idEObject.eGet((EStructuralFeature)eReference) != null || (eGet = this.resultModel.getByGuid(guid).eGet((EStructuralFeature)eReference)) == null || !(eGet instanceof IfcRoot) || !this.newModel.containsGuid(oldGuid = ((IfcRoot)eGet).getGlobalId())) continue;
                this.resultModel.getByGuid(guid).eSet((EStructuralFeature)eReference, null);
            }
        }
    }

    private void updateReferences() {
        for (IdEObject idEObject : this.newModel.getValues()) {
            if (!(idEObject instanceof IfcRoot)) continue;
            String guid = ((IfcRoot)idEObject).getGlobalId();
            IfcRoot oldObject = this.resultModel.getByGuid(guid);
            for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                Object referencedObject = idEObject.eGet((EStructuralFeature)eReference);
                if (referencedObject instanceof IfcRoot) {
                    String referencedGuid = ((IfcRoot)referencedObject).getGlobalId();
                    IfcRoot newObject = this.resultModel.getByGuid(referencedGuid);
                    oldObject.eSet((EStructuralFeature)eReference, (Object)newObject);
                    continue;
                }
                if (!(referencedObject instanceof List)) continue;
                List referencedList = (List)referencedObject;
                List oldReferencedList = (List)oldObject.eGet((EStructuralFeature)eReference);
                for (Object object : referencedList) {
                    if (!(object instanceof IfcRoot)) continue;
                    IfcRoot referencedItem = (IfcRoot)object;
                    String itemGuid = referencedItem.getGlobalId();
                    oldReferencedList.add(this.resultModel.getByGuid(itemGuid));
                }
            }
        }
    }

    private void copyAttributesGuidObjectsAndAddNewObjects() throws IfcModelInterfaceException {
        for (IdEObject idEObject : this.newModel.getValues()) {
            if (!(idEObject instanceof IfcRoot)) continue;
            IfcRoot ifcRoot = (IfcRoot)idEObject;
            String guid = ifcRoot.getGlobalId();
            if (this.resultModel.containsGuid(guid)) {
                IfcRoot oldObject = this.resultModel.getByGuid(guid);
                for (EAttribute eAttribute : idEObject.eClass().getEAllAttributes()) {
                    Object newValue = idEObject.eGet((EStructuralFeature)eAttribute);
                    oldObject.eSet((EStructuralFeature)eAttribute, newValue);
                }
                continue;
            }
            IdEObject newObject = (IdEObject)idEObject.eClass().getEPackage().getEFactoryInstance().create(idEObject.eClass());
            ((IdEObjectImpl)newObject).setOid(idEObject.getOid());
            ((IfcRoot)newObject).setGlobalId(this.newGuid(guid));
            for (EAttribute eAttribute : newObject.eClass().getEAllAttributes()) {
                newObject.eSet((EStructuralFeature)eAttribute, idEObject.eGet((EStructuralFeature)eAttribute));
            }
            this.resultModel.add(newObject.getOid(), newObject);
        }
    }

    private String newGuid(String guid) {
        return guid;
    }
}

