/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.client.SimpleTokenHolder;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.client.json.JsonSocketReflectorFactory;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.interfaces.objects.SObjectType;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.ServiceDescriptor;
import org.bimserver.models.store.StorePackage;
import org.bimserver.notifications.InternalChannel;
import org.bimserver.plugins.NotificationsManagerInterface;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.plugins.services.NewExtendedDataOnProjectHandler;
import org.bimserver.plugins.services.NewExtendedDataOnRevisionHandler;
import org.bimserver.plugins.services.NewRevisionHandler;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.TokenAuthentication;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.Bimsie1RemoteServiceInterfaceAdaptor;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.shared.reflector.FileBasedReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;
import org.bimserver.webservices.ServiceMap;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServicesManager
implements NotificationsManagerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalServicesManager.class);
    private final Map<Long, Map<String, ServiceDescriptor>> uoidToInternalServices = new HashMap<Long, Map<String, ServiceDescriptor>>();
    private final Map<String, Bimsie1RemoteServiceInterface> internalRemoteServiceInterfaces = new HashMap<String, Bimsie1RemoteServiceInterface>();
    private final Map<String, BimServerClientFactory> factories = new HashMap<String, BimServerClientFactory>();
    private BimServer bimServer;
    private String url;

    public InternalServicesManager(BimServer bimServer, String url) {
        this.bimServer = bimServer;
        this.url = url;
    }

    public void register(long uoid, ServiceDescriptor serviceDescriptor, Bimsie1RemoteServiceInterface remoteServiceInterface) {
        serviceDescriptor.setUrl(this.url);
        Map<String, ServiceDescriptor> map = this.uoidToInternalServices.get(uoid);
        if (map == null) {
            map = new HashMap<String, ServiceDescriptor>();
            this.uoidToInternalServices.put(uoid, map);
        }
        map.put(serviceDescriptor.getIdentifier(), serviceDescriptor);
        this.internalRemoteServiceInterfaces.put(serviceDescriptor.getIdentifier(), remoteServiceInterface);
    }

    public ServiceDescriptor getInternalService(Long uoid, String serviceIdentifier) {
        for (Map.Entry<Long, Map<String, ServiceDescriptor>> entry : this.uoidToInternalServices.entrySet()) {
            if (!entry.getValue().containsKey(serviceIdentifier)) continue;
            return entry.getValue().get(serviceIdentifier);
        }
        return null;
    }

    public Map<String, ServiceDescriptor> getInternalServices(long uoid) {
        return this.uoidToInternalServices.get(uoid);
    }

    public Bimsie1RemoteServiceInterface getLocalRemoteServiceInterface(String serviceIdentifier) {
        return this.internalRemoteServiceInterfaces.get(serviceIdentifier);
    }

    public void registerInternalNewExtendedDataOnRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, final NewExtendedDataOnRevisionHandler newExtendedDataHandler) {
        this.register(uoid, serviceDescriptor, (Bimsie1RemoteServiceInterface)new Bimsie1RemoteServiceInterfaceAdaptor(){

            public void newExtendedDataOnRevision(Long poid, Long roid, Long edid, Long soid, String serviceIdentifier, String profileIdentifier, String userToken, String token, String apiUrl) throws UserException, ServerException {
                P p = InternalServicesManager.this.getBimServerClient(serviceIdentifier, profileIdentifier, apiUrl, token);
                newExtendedDataHandler.newExtendedDataOnRevision(p.client, poid.longValue(), roid.longValue(), edid.longValue(), userToken, soid.longValue(), p.settings);
            }
        });
    }

    public void registerInternalNewExtendedDataOnProjectHandler(long uoid, ServiceDescriptor serviceDescriptor, final NewExtendedDataOnProjectHandler newExtendedDataHandler) {
        this.register(uoid, serviceDescriptor, (Bimsie1RemoteServiceInterface)new Bimsie1RemoteServiceInterfaceAdaptor(){

            public void newExtendedDataOnProject(Long poid, Long edid, Long soid, String serviceIdentifier, String profileIdentifier, String userToken, String token, String apiUrl) throws UserException, ServerException {
                P p = InternalServicesManager.this.getBimServerClient(serviceIdentifier, profileIdentifier, apiUrl, token);
                newExtendedDataHandler.newExtendedDataOnProject(p.client, poid.longValue(), edid.longValue(), userToken, soid.longValue(), p.settings);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P getBimServerClient(String serviceIdentifier, String profileIdentifier, String apiUrl, String token) {
        ServiceMap serviceMapInterface = new ServiceMap(this.bimServer, null, AccessMethod.JSON);
        serviceMapInterface.add(Bimsie1RemoteServiceInterface.class, (PublicInterface)this.internalRemoteServiceInterfaces.get(serviceIdentifier));
        P p = new P();
        InternalChannel internalChannel = new InternalChannel(this.bimServer.getServiceFactory(), this.bimServer.getServicesMap());
        try {
            internalChannel.connect((TokenHolder)new SimpleTokenHolder());
        }
        catch (ChannelConnectionException e) {
            LOGGER.error("", (Throwable)e);
        }
        try (DatabaseSession session = this.bimServer.getDatabase().createSession();){
            long profileId = Long.parseLong(profileIdentifier);
            EClass eClassForOid = session.getEClassForOid(profileId);
            InternalServicePluginConfiguration internalServicePluginConfiguration = null;
            if (eClassForOid == StorePackage.eINSTANCE.getInternalServicePluginConfiguration()) {
                internalServicePluginConfiguration = (InternalServicePluginConfiguration)session.get(profileId, OldQuery.getDefault());
            } else if (eClassForOid == StorePackage.eINSTANCE.getService()) {
                Service service = (Service)session.get(profileId, OldQuery.getDefault());
                internalServicePluginConfiguration = service.getInternalService();
            } else {
                throw new RuntimeException("Oid is neither an InternalServicePluginConfiguration nor a Service");
            }
            SObjectType settings = this.bimServer.getSConverter().convertToSObject(internalServicePluginConfiguration.getSettings());
            BimServerClientInterface bimServerClient = null;
            BimServerClientFactory factory = null;
            if (apiUrl == null) {
                factory = this.bimServer.getBimServerClientFactory();
            } else if (this.factories.containsKey(apiUrl)) {
                factory = this.factories.get(apiUrl);
            } else {
                FileBasedReflectorFactoryBuilder reflectorBuilder = new FileBasedReflectorFactoryBuilder();
                ReflectorFactory reflectorFactory = reflectorBuilder.newReflectorFactory();
                factory = new JsonBimServerClientFactory(apiUrl, this.bimServer.getServicesMap(), new JsonSocketReflectorFactory(this.bimServer.getServicesMap()), reflectorFactory, this.bimServer.getMetaDataManager());
                this.factories.put(apiUrl, factory);
            }
            p.client = bimServerClient = factory.create((AuthenticationInfo)new TokenAuthentication(token));
            p.settings = settings;
            P p2 = p;
            return p2;
        }
        return null;
    }

    public void registerInternalNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, final NewRevisionHandler newRevisionHandler) {
        this.register(uoid, serviceDescriptor, (Bimsie1RemoteServiceInterface)new Bimsie1RemoteServiceInterfaceAdaptor(){

            public void newRevision(final Long poid, final Long roid, final Long soid, String serviceIdentifier, String profileIdentifier, final String userToken, String token, String apiUrl) throws UserException, ServerException {
                final P p = InternalServicesManager.this.getBimServerClient(serviceIdentifier, profileIdentifier, apiUrl, token);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            newRevisionHandler.newRevision(p.client, poid.longValue(), roid.longValue(), userToken, soid.longValue(), p.settings);
                        }
                        catch (ServerException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        catch (UserException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                }.start();
            }
        });
    }

    public void unregisterInternalNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor) {
        Map<String, ServiceDescriptor> map = this.uoidToInternalServices.get(uoid);
        if (map != null) {
            map.remove(serviceDescriptor.getIdentifier());
        }
        this.internalRemoteServiceInterfaces.remove(serviceDescriptor.getIdentifier());
    }

    private class P {
        public BimServerClientInterface client;
        public SObjectType settings;

        private P() {
        }
    }
}

