/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.client.Channel;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.Trigger;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopic;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopicKey;
import org.bimserver.notifications.Notification;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.async.AsyncBimsie1RemoteServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewExtendedDataOnRevisionNotification
extends Notification {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewExtendedDataOnRevisionNotification.class);
    private Long roid;
    private Long edid;
    private long soid;
    private long poid;

    public NewExtendedDataOnRevisionNotification(BimServer bimServer, Long edid, long poid, Long roid, long soid) {
        super(bimServer);
        this.edid = edid;
        this.poid = poid;
        this.roid = roid;
        this.soid = soid;
    }

    public long getRoid() {
        return this.roid;
    }

    public long getEdid() {
        return this.edid;
    }

    public long getPoid() {
        return this.poid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws BimserverDatabaseException, UserException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            NewExtendedDataOnRevisionTopic topic;
            Project project = (Project)session.get(StorePackage.eINSTANCE.getProject(), this.poid, (QueryInterface)OldQuery.getDefault());
            for (Service service : project.getServices()) {
                if (this.soid != -1L && service.getOid() != this.soid) continue;
                this.triggerNewExtendedData(session, this.getBimServer().getNotificationsManager(), this.getBimServer(), this.getBimServer().getNotificationsManager().getSiteAddress(), project, this.roid, Trigger.NEW_EXTENDED_DATA, service);
            }
            if (this.soid == -1L && (topic = this.getBimServer().getNotificationsManager().getNewExtendedDataOnRevisionTopic(new NewExtendedDataOnRevisionTopicKey(this.roid))) != null) {
                topic.process(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNewExtendedData(DatabaseSession session, NotificationsManager notificationsManager, BimServer bimServer, String siteAddress, Project project, long roid, Trigger trigger, Service service) throws UserException, ServerException {
        if (service.getTrigger() == trigger) {
            Channel channel = null;
            try {
                channel = notificationsManager.getChannel(service);
                Bimsie1RemoteServiceInterface remoteServiceInterface = (Bimsie1RemoteServiceInterface)channel.get(Bimsie1RemoteServiceInterface.class);
                long writeProjectPoid = service.getWriteRevision() == null ? -1L : service.getWriteRevision().getOid();
                long writeExtendedDataRoid = service.getWriteExtendedData() != null ? roid : -1L;
                long readRevisionRoid = service.isReadRevision() ? roid : -1L;
                long readExtendedDataRoid = service.getReadExtendedData() != null ? roid : -1L;
                ExplicitRightsAuthorization authorization = new ExplicitRightsAuthorization(bimServer, service.getUser().getOid(), service.getOid(), new long[]{readRevisionRoid}, writeProjectPoid, readExtendedDataRoid, writeExtendedDataRoid);
                ServiceInterface newService = bimServer.getServiceFactory().get(authorization, AccessMethod.INTERNAL).get(ServiceInterface.class);
                ((ServiceImpl)newService).setAuthorization(authorization);
                AsyncBimsie1RemoteServiceInterface asyncRemoteServiceInterface = new AsyncBimsie1RemoteServiceInterface(remoteServiceInterface, bimServer.getExecutorService());
                asyncRemoteServiceInterface.newExtendedDataOnRevision(Long.valueOf(this.poid), Long.valueOf(roid), this.edid, Long.valueOf(this.soid), service.getServiceIdentifier(), service.getProfileIdentifier(), service.getToken(), authorization.asHexToken(bimServer.getEncryptionKey()), bimServer.getServerSettingsCache().getServerSettings().getSiteAddress(), new AsyncBimsie1RemoteServiceInterface.NewExtendedDataOnRevisionCallback(){

                    public void success() {
                    }

                    public void error(Throwable e) {
                        LOGGER.error("", e);
                    }
                });
                asyncRemoteServiceInterface.newRevision(Long.valueOf(this.poid), Long.valueOf(roid), Long.valueOf(service.getOid()), service.getServiceIdentifier(), service.getProfileIdentifier(), service.getToken(), authorization.asHexToken(bimServer.getEncryptionKey()), bimServer.getServerSettingsCache().getServerSettings().getSiteAddress(), new AsyncBimsie1RemoteServiceInterface.NewRevisionCallback(){

                    public void success() {
                    }

                    public void error(Throwable e) {
                        LOGGER.error("", e);
                    }
                });
            }
            catch (ChannelConnectionException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (PublicInterfaceNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
    }
}

