/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.notifications.ChangeProgressTopicOnProjectTopic;
import org.bimserver.notifications.Notification;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewProgressTopicOnProjectNotification
extends Notification {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewProgressTopicOnProjectNotification.class);
    private long topicId;
    private long poid;

    public NewProgressTopicOnProjectNotification(BimServer bimServer, long poid, long topicId) {
        super(bimServer);
        this.poid = poid;
        this.topicId = topicId;
    }

    public long getTopicId() {
        return this.topicId;
    }

    public long getPoid() {
        return this.poid;
    }

    @Override
    public void process() {
        ChangeProgressTopicOnProjectTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnProjectTopic(this.poid);
        try {
            changeProgressOnProjectTopic.notifyOfNewTopic(this);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

