/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.notifications.ChangeProgressTopicOnProjectTopic;
import org.bimserver.notifications.ChangeProgressTopicOnRevisionTopic;
import org.bimserver.notifications.ChangeProgressTopicOnServerTopic;
import org.bimserver.notifications.NewProgressTopicOnProjectNotification;
import org.bimserver.notifications.NewProgressTopicOnServerNotification;
import org.bimserver.notifications.Notification;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class NewProgressTopicOnRevisionNotification
extends Notification {
    private long poid;
    private long roid;
    private long topicId;

    public NewProgressTopicOnRevisionNotification(BimServer bimServer, long poid, long roid, long topicId) {
        super(bimServer);
        this.poid = poid;
        this.roid = roid;
        this.topicId = topicId;
    }

    public long getTopicId() {
        return this.topicId;
    }

    public long getPoid() {
        return this.poid;
    }

    public long getRoid() {
        return this.roid;
    }

    @Override
    public void process() throws UserException, ServerException, BimserverDatabaseException {
        ChangeProgressTopicOnRevisionTopic changeProgressOnRevisionTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnRevisionTopic(this.poid, this.roid);
        changeProgressOnRevisionTopic.notifyOfNewTopic(this);
        ChangeProgressTopicOnProjectTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnProjectTopic(this.poid);
        changeProgressOnProjectTopic.notifyOfNewTopic(new NewProgressTopicOnProjectNotification(this.getBimServer(), this.poid, this.topicId));
        ChangeProgressTopicOnServerTopic changeProgressTopicOnServerTopic = this.getBimServer().getNotificationsManager().getChangeProgressTopicOnServerTopic();
        changeProgressTopicOnServerTopic.notifyOfNewTopic(new NewProgressTopicOnServerNotification(this.getBimServer(), this.topicId));
    }
}

