/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.client.Channel;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.mail.EmailMessage;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ModelCheckerInstance;
import org.bimserver.models.store.ModelCheckerResult;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.Trigger;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopic;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopicKey;
import org.bimserver.notifications.NewRevisionTopic;
import org.bimserver.notifications.Notification;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.plugins.modelchecker.ModelCheckException;
import org.bimserver.plugins.modelchecker.ModelChecker;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.async.AsyncBimsie1RemoteServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.templating.TemplateIdentifier;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.authorization.UserAuthorization;
import org.bimserver.webservices.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRevisionNotification
extends Notification {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewRevisionNotification.class);
    private long roid;
    private long poid;
    private long soid;
    private boolean sendEmail = true;

    public NewRevisionNotification(BimServer bimServer, long poid, long roid, long soid) {
        super(bimServer);
        this.poid = poid;
        this.roid = roid;
        this.soid = soid;
        this.sendEmail = false;
    }

    public NewRevisionNotification(BimServer bimServer, long poid, long roid) {
        super(bimServer);
        this.poid = poid;
        this.roid = roid;
        this.soid = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws BimserverDatabaseException, UserException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Project project = (Project)session.get(StorePackage.eINSTANCE.getProject(), this.poid, (QueryInterface)OldQuery.getDefault());
            if (project == null) {
                LOGGER.error("Project with oid " + this.poid + " not found");
                return;
            }
            Revision revision = (Revision)session.get(StorePackage.eINSTANCE.getRevision(), this.roid, (QueryInterface)OldQuery.getDefault());
            if (revision == null) {
                LOGGER.error("Revision with roid " + this.roid + " not found");
                return;
            }
            if (project.isSendEmailOnNewRevision() && this.sendEmail) {
                this.sendEmail(session, project, revision);
            }
            for (Service service : project.getServices()) {
                if (this.soid != -1L && service.getOid() != this.soid) continue;
                this.triggerNewRevision(session, this.getBimServer().getNotificationsManager(), this.getBimServer(), this.getBimServer().getNotificationsManager().getSiteAddress(), project, this.roid, Trigger.NEW_REVISION, service);
            }
            if (this.soid == -1L) {
                NewRevisionOnSpecificProjectTopic newRevisionOnSpecificProjectTopic;
                NewRevisionTopic newRevisionTopic = this.getBimServer().getNotificationsManager().getNewRevisionTopic();
                if (newRevisionTopic != null) {
                    newRevisionTopic.process(session, this.poid, this.roid, this);
                }
                if ((newRevisionOnSpecificProjectTopic = this.getBimServer().getNotificationsManager().getNewRevisionOnSpecificProjectTopic(new NewRevisionOnSpecificProjectTopicKey(this.poid))) != null) {
                    newRevisionOnSpecificProjectTopic.process(session, this.poid, this.roid, this);
                }
            }
        }
    }

    private void sendEmail(DatabaseSession session, Project project, Revision revision) {
        Set<User> users = this.getUsers(session, project);
        for (User user : users) {
            String body = null;
            try {
                if (!MailSystem.isValidEmailAddress(user.getUsername())) continue;
                EmailMessage message = this.getBimServer().getMailSystem().createMessage();
                ServerSettings serverSettings = this.getBimServer().getServerSettingsCache().getServerSettings();
                String emailSenderAddress = serverSettings.getEmailSenderAddress();
                InternetAddress addressFrom = new InternetAddress(emailSenderAddress);
                message.setFrom(addressFrom);
                InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(user.getUsername())};
                message.setRecipients(Message.RecipientType.TO, addressTo);
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("name", user.getName());
                context.put("username", user.getUsername());
                context.put("siteaddress", serverSettings.getSiteAddress());
                context.put("revisionId", revision.getId());
                Authorization authorization = null;
                authorization = user.getUserType() == UserType.ADMIN ? new AdminAuthorization(this.getBimServer().getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS) : new UserAuthorization(this.getBimServer().getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
                authorization.setUoid(user.getOid());
                String asHexToken = authorization.asHexToken(this.getBimServer().getEncryptionKey());
                context.put("token", asHexToken);
                context.put("roid", revision.getOid());
                context.put("comment", revision.getComment());
                context.put("projectName", project.getName());
                String subject = null;
                body = this.getBimServer().getTemplateEngine().process(context, TemplateIdentifier.NEW_REVISION_EMAIL_BODY);
                subject = this.getBimServer().getTemplateEngine().process(context, TemplateIdentifier.NEW_REVISION_EMAIL_SUBJECT);
                message.setContent(body, "text/html");
                message.setSubject(subject.trim());
                LOGGER.info("Sending new revision e-mail to " + user.getUsername());
                message.send();
            }
            catch (Exception e) {
                LOGGER.error(body);
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private Set<User> getUsers(DatabaseSession session, Project project) {
        Set<Project> relatedProjects = this.getRelatedProjects(project);
        HashSet<User> users = new HashSet<User>();
        for (Project relatedProject : relatedProjects) {
            for (User user : relatedProject.getHasAuthorizedUsers()) {
                users.add(user);
            }
        }
        return users;
    }

    private Set<Project> getRelatedProjects(Project project) {
        HashSet<Project> projects = new HashSet<Project>();
        Project rootProject = this.getRootProject(project);
        this.getAllSubProjects(projects, rootProject);
        return projects;
    }

    private Project getRootProject(Project project) {
        if (project.getParent() != null) {
            return this.getRootProject(project.getParent());
        }
        return project;
    }

    private void getAllSubProjects(Set<Project> projects, Project project) {
        projects.add(project);
        for (Project subProject : project.getSubProjects()) {
            this.getAllSubProjects(projects, subProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNewRevision(DatabaseSession session, NotificationsManager notificationsManager, BimServer bimServer, String siteAddress, Project project, long roid, Trigger trigger, Service service) throws UserException, ServerException {
        if (service.getTrigger() == trigger) {
            Channel channel = null;
            try {
                BasicIfcModel model = null;
                for (ModelCheckerInstance modelCheckerInstance : service.getModelCheckers()) {
                    ModelCheckerPlugin modelCheckerPlugin;
                    if (!modelCheckerInstance.isValid() || (modelCheckerPlugin = bimServer.getPluginManager().getModelCheckerPlugin(modelCheckerInstance.getModelCheckerPluginClassName(), true)) == null) continue;
                    ModelChecker modelChecker = modelCheckerPlugin.createModelChecker(null);
                    try {
                        ModelCheckerResult result;
                        if (model == null) {
                            PackageMetaData packageMetaData = bimServer.getMetaDataManager().getPackageMetaData(project.getSchema());
                            model = new BasicIfcModel(packageMetaData, null);
                            try {
                                Revision revision = (Revision)session.get(roid, OldQuery.getDefault());
                                session.getMap((IfcModelInterface)model, new OldQuery(packageMetaData, project.getId(), revision.getId(), revision.getOid(), null, OldQuery.Deep.NO));
                            }
                            catch (BimserverDatabaseException e) {
                                LOGGER.error("", (Throwable)e);
                            }
                        }
                        if ((result = modelChecker.check(model, modelCheckerInstance.getCompiled())).isValid()) continue;
                        LOGGER.info("Not triggering");
                        return;
                    }
                    catch (ModelCheckException e) {
                        LOGGER.info("Not triggering");
                        return;
                    }
                }
                channel = notificationsManager.getChannel(service);
                Bimsie1RemoteServiceInterface remoteServiceInterface = (Bimsie1RemoteServiceInterface)channel.get(Bimsie1RemoteServiceInterface.class);
                long writeProjectPoid = service.getWriteRevision() == null ? -1L : service.getWriteRevision().getOid();
                long writeExtendedDataRoid = service.getWriteExtendedData() != null ? roid : -1L;
                long readRevisionRoid = service.isReadRevision() ? roid : -1L;
                long readExtendedDataRoid = service.getReadExtendedData() != null ? roid : -1L;
                ArrayList<Long> roidsList = new ArrayList<Long>();
                Set<Project> relatedProjects = this.getRelatedProjects(project);
                for (Project p : relatedProjects) {
                    if (p.getLastRevision() == null) continue;
                    roidsList.add(p.getLastRevision().getOid());
                }
                long[] roids = new long[roidsList.size()];
                for (int i = 0; i < roids.length; ++i) {
                    roids[i] = (Long)roidsList.get(i);
                }
                ExplicitRightsAuthorization authorization = new ExplicitRightsAuthorization(bimServer, service.getUser().getOid(), service.getOid(), service.isReadRevision() ? roids : new long[]{}, writeProjectPoid, readExtendedDataRoid, writeExtendedDataRoid);
                ServiceInterface newService = bimServer.getServiceFactory().get(authorization, AccessMethod.INTERNAL).get(ServiceInterface.class);
                ((ServiceImpl)newService).setAuthorization(authorization);
                AsyncBimsie1RemoteServiceInterface asyncRemoteServiceInterface = new AsyncBimsie1RemoteServiceInterface(remoteServiceInterface, bimServer.getExecutorService());
                asyncRemoteServiceInterface.newRevision(Long.valueOf(this.poid), Long.valueOf(roid), Long.valueOf(service.getOid()), service.getServiceIdentifier(), service.getProfileIdentifier(), service.getToken(), authorization.asHexToken(bimServer.getEncryptionKey()), bimServer.getServerSettingsCache().getServerSettings().getSiteAddress(), new AsyncBimsie1RemoteServiceInterface.NewRevisionCallback(){

                    public void success() {
                    }

                    public void error(Throwable e) {
                        LOGGER.error("", e);
                    }
                });
            }
            catch (ChannelConnectionException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (PublicInterfaceNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
    }
}

