/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.QueryInterface;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.notifications.NewRevisionNotification;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.notifications.Topic;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class NewRevisionTopic
extends Topic {
    public NewRevisionTopic(NotificationsManager notificationsManager) {
        super(notificationsManager);
    }

    public void process(final DatabaseSession session, final long poid, final long roid, NewRevisionNotification newRevisionNotification) throws BimserverDatabaseException, UserException, ServerException {
        this.map(new Topic.Mapper(){

            @Override
            public void map(EndPoint endPoint) throws UserException, ServerException, BimserverDatabaseException {
                User user = (User)session.get(StorePackage.eINSTANCE.getUser(), endPoint.getUoid(), (QueryInterface)OldQuery.getDefault());
                Project project = (Project)session.get(StorePackage.eINSTANCE.getUser(), poid, (QueryInterface)OldQuery.getDefault());
                if (user.getUserType() == UserType.ADMIN || user.getHasRightsOn().contains((Object)project)) {
                    endPoint.getNotificationInterface().newRevision(Long.valueOf(poid), Long.valueOf(roid));
                }
            }
        });
    }

    @Override
    public void remove() {
    }
}

