/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.Repo;
import com.jcabi.github.RtGithub;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bimserver.plugins.GitHubPluginVersion;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginLocation;

public class GitHubPluginLocation
extends PluginLocation<GitHubPluginVersion> {
    private final String repository;
    private final String groupId;
    private final String artifactId;

    public GitHubPluginLocation(String repository, String groupId, String artifactId) {
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public List<GitHubPluginVersion> getAllVersions() {
        ArrayList<GitHubPluginVersion> versions = new ArrayList<GitHubPluginVersion>();
        RtGithub github = new RtGithub();
        String substring = this.repository.substring(this.repository.lastIndexOf("/", this.repository.lastIndexOf("/") - 1) + 1);
        Repo repo = github.repos().get((Coordinates)new Coordinates.Simple(substring));
        for (Release release : repo.releases().iterate()) {
            try {
                System.out.println(release.json());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return versions;
    }

    @Override
    public PluginBundleIdentifier getPluginIdentifier() {
        return new PluginBundleIdentifier(this.groupId, this.artifactId);
    }

    public String getRepository() {
        return this.repository;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

