/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.bimserver.plugins.GitHubPluginLocation;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPluginRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPluginLocation.class);
    private final MavenPluginRepository mavenPluginRepository;
    private final String url;

    public GitHubPluginRepository(MavenPluginRepository mavenPluginRepository, String organization, String repository) {
        this.mavenPluginRepository = mavenPluginRepository;
        this.url = "https://github.com/" + organization + "/" + repository + "/raw/master/plugins.json";
    }

    public GitHubPluginRepository(MavenPluginRepository mavenPluginRepository, String url) {
        this.mavenPluginRepository = mavenPluginRepository;
        this.url = url + "/plugins.json";
    }

    public List<PluginLocation<?>> listPluginLocations() {
        ArrayList pluginLocations = new ArrayList();
        try {
            String content = NetUtils.getContent((URL)new URL(this.url), (int)5000);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode objectNode = (ObjectNode)objectMapper.readValue(content, ObjectNode.class);
            ArrayNode pluginsNode = (ArrayNode)objectNode.get("plugins");
            for (JsonNode pluginNode : pluginsNode) {
                ObjectNode pluginObject = (ObjectNode)pluginNode;
                if (pluginObject.has("maven")) {
                    ObjectNode mavenNode = (ObjectNode)pluginObject.get("maven");
                    MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(mavenNode.get("defaultrepository").asText(), mavenNode.get("groupId").asText(), mavenNode.get("artifactId").asText());
                    pluginLocations.add(mavenPluginLocation);
                    continue;
                }
                if (pluginObject.has("github")) {
                    LOGGER.warn("GitHub plugins have been disabled because of GitHub API limits");
                    continue;
                }
                LOGGER.info("Unknown plugin type " + pluginObject.toString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pluginLocations;
    }
}

