/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleType;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.plugins.MavenDependency;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.MavenPluginVersion;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginBundleVersionIdentifier;
import org.bimserver.plugins.PluginLocation;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

public class MavenPluginLocation
extends PluginLocation<MavenPluginVersion> {
    private String defaultrepository;
    private String groupId;
    private String artifactId;
    private MavenPluginRepository mavenPluginRepository;
    private String repository;

    protected MavenPluginLocation(MavenPluginRepository mavenPluginRepository, String defaultrepository, String groupId, String artifactId) {
        this.mavenPluginRepository = mavenPluginRepository;
        this.defaultrepository = defaultrepository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.repository = mavenPluginRepository.getRemoteRepositoryUrl();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String toString() {
        return this.groupId + "." + this.artifactId;
    }

    @Override
    public List<MavenPluginVersion> getAllVersions() {
        ArrayList<MavenPluginVersion> pluginVersions = new ArrayList<MavenPluginVersion>();
        DefaultArtifact artifact = new DefaultArtifact(this.groupId + ":" + this.artifactId + ":[0,)");
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifact);
        rangeRequest.setRepositories(this.mavenPluginRepository.getRepositories());
        try {
            VersionRangeResult rangeResult = this.mavenPluginRepository.getSystem().resolveVersionRange(this.mavenPluginRepository.getSession(), rangeRequest);
            List versions = rangeResult.getVersions();
            for (Version version : versions) {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                DefaultArtifact versionArtifact = new DefaultArtifact(this.groupId + ":" + this.artifactId + ":pom:" + version.toString());
                descriptorRequest.setArtifact((Artifact)versionArtifact);
                descriptorRequest.setRepositories(this.mavenPluginRepository.getRepositories());
                MavenPluginVersion mavenPluginVersion = new MavenPluginVersion((Artifact)versionArtifact, version);
                ArtifactDescriptorResult descriptorResult = this.mavenPluginRepository.getSystem().readArtifactDescriptor(this.mavenPluginRepository.getSession(), descriptorRequest);
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact(descriptorResult.getArtifact());
                request.setRepositories(this.mavenPluginRepository.getRepositories());
                ArtifactResult resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
                File pomFile = resolveArtifact.getArtifact().getFile();
                MavenXpp3Reader mavenreader = new MavenXpp3Reader();
                try {
                    Model model = mavenreader.read((Reader)new FileReader(pomFile));
                    mavenPluginVersion.setModel(model);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(dependency.getArtifact().getVersion());
                    mavenPluginVersion.addDependency(new MavenDependency(dependency.getArtifact(), artifactVersion));
                }
                pluginVersions.add(mavenPluginVersion);
            }
        }
        catch (VersionRangeResolutionException e) {
            e.printStackTrace();
        }
        catch (ArtifactDescriptorException e) {
            e.printStackTrace();
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
        }
        return pluginVersions;
    }

    public Path getVersionJar(String version) throws ArtifactResolutionException {
        DefaultArtifact versionArtifact = new DefaultArtifact(this.groupId + ":" + this.artifactId + ":" + version.toString());
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)versionArtifact);
        request.setRepositories(this.mavenPluginRepository.getRepositories());
        ArtifactResult resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
        return resolveArtifact.getArtifact().getFile().toPath();
    }

    public Path getVersionPluginXml(String version) throws ArtifactResolutionException {
        DefaultArtifact versionArtifact = new DefaultArtifact(this.groupId, this.artifactId, "plugin", "xml", version.toString());
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)versionArtifact);
        request.setRepositories(this.mavenPluginRepository.getRepositories());
        ArtifactResult resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
        return resolveArtifact.getArtifact().getFile().toPath();
    }

    @Override
    public PluginBundleIdentifier getPluginIdentifier() {
        return new PluginBundleIdentifier(this.groupId, this.artifactId);
    }

    public SPluginBundle getPluginBundle(String version) {
        try {
            DefaultArtifact versionArtifact = new DefaultArtifact(this.groupId + ":" + this.artifactId + ":pom:" + version);
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)versionArtifact);
            request.setRepositories(this.mavenPluginRepository.getRepositories());
            ArtifactResult resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
            File pomFile = resolveArtifact.getArtifact().getFile();
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            Model model = mavenreader.read((Reader)new FileReader(pomFile));
            SPluginBundle sPluginBundle = new SPluginBundle();
            sPluginBundle.setOrganization(model.getOrganization().getName());
            sPluginBundle.setName(model.getName());
            return sPluginBundle;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SPluginBundleVersion getPluginBundleVersion(String version) {
        try {
            DefaultArtifact versionArtifact = new DefaultArtifact(this.groupId + ":" + this.artifactId + ":pom:" + version.toString());
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)versionArtifact);
            request.setRepositories(this.mavenPluginRepository.getRepositories());
            ArtifactResult resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
            Artifact artifact = resolveArtifact.getArtifact();
            File pomFile = resolveArtifact.getArtifact().getFile();
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            Model model = mavenreader.read((Reader)new FileReader(pomFile));
            SPluginBundleVersion sPluginBundleVersion = new SPluginBundleVersion();
            sPluginBundleVersion.setType(SPluginBundleType.MAVEN);
            sPluginBundleVersion.setGroupId(artifact.getGroupId());
            sPluginBundleVersion.setArtifactId(artifact.getArtifactId());
            sPluginBundleVersion.setVersion(version);
            sPluginBundleVersion.setDescription(model.getDescription());
            sPluginBundleVersion.setRepository(this.defaultrepository);
            sPluginBundleVersion.setMismatch(false);
            return sPluginBundleVersion;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public PluginBundleVersionIdentifier getPluginVersionIdentifier(String version) {
        return new PluginBundleVersionIdentifier(this.getPluginIdentifier(), version);
    }

    public String getRepository() {
        return this.repository;
    }
}

