/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.bimserver.plugins.ConsoleRepositoryListener;
import org.bimserver.plugins.ConsoleTransferListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;

public class RemotePluginRepository {
    public static void main(String[] args) throws ArtifactResolutionException {
        System.out.println("------------------------------------------------------------");
        System.out.println(RemotePluginRepository.class.getSimpleName());
        RepositorySystem system = RemotePluginRepository.newRepositorySystem();
        DefaultRepositorySystemSession session = RemotePluginRepository.newRepositorySystemSession(system);
        DefaultArtifact artifact = new DefaultArtifact("org.eclipse.aether:aether-util:1.0.0.v20140518");
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(RemotePluginRepository.newRepositories(system, (RepositorySystemSession)session));
        ArtifactResult artifactResult = system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
        artifact = artifactResult.getArtifact();
        System.out.println(artifact + " resolved to  " + artifact.getFile());
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository("target/local-repo");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    public static List<RemoteRepository> newRepositories(RepositorySystem system, RepositorySystemSession session) {
        return new ArrayList<RemoteRepository>(Arrays.asList(RemotePluginRepository.newCentralRepository()));
    }

    private static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build();
    }
}

