/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.renderengine;

import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.renderengine.RenderEngineFactory;

public class RenderEnginePool {
    private final Queue<RenderEngine> available;
    private final Set<RenderEngine> busy;
    private final Queue<CountDownLatch> waiting = new ArrayBlockingQueue<CountDownLatch>(1000);

    public RenderEnginePool(int poolSize, RenderEngineFactory renderEngineFactory) throws RenderEngineException {
        this.available = new ArrayBlockingQueue<RenderEngine>(poolSize);
        this.busy = new HashSet<RenderEngine>();
        for (int i = 0; i < poolSize; ++i) {
            this.available.add(renderEngineFactory.createRenderEngine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderEngine request() throws InterruptedException {
        CountDownLatch latch = null;
        RenderEnginePool renderEnginePool = this;
        synchronized (renderEnginePool) {
            if (!this.available.isEmpty()) {
                return this.getRenderEngineSafe();
            }
            latch = new CountDownLatch(1);
            this.waiting.add(latch);
        }
        if (latch != null) {
            latch.await();
            renderEnginePool = this;
            synchronized (renderEnginePool) {
                return this.getRenderEngineSafe();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RenderEngine renderEngine) {
        RenderEnginePool renderEnginePool = this;
        synchronized (renderEnginePool) {
            this.busy.remove(renderEngine);
            this.available.add(renderEngine);
            CountDownLatch countDownLatch = this.waiting.poll();
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }

    public RenderEngine getRenderEngineSafe() {
        RenderEngine renderEngine = this.available.poll();
        this.busy.add(renderEngine);
        return renderEngine;
    }
}

