/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.renderengine;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.emf.Schema;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.renderengine.RenderEngineFactory;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.exceptions.PluginException;

public class RenderEnginePools {
    private BimServer bimServer;
    private final Map<Schema, Map<String, RenderEnginePool>> pools = new HashMap<Schema, Map<String, RenderEnginePool>>();

    public RenderEnginePools(BimServer bimServer) throws RenderEngineException {
        this.bimServer = bimServer;
        int nrRenderEngineProcesses = this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses();
        Collection renderEnginePlugins = bimServer.getPluginManager().getAllRenderEnginePlugins(true).values();
        for (final Schema schema : Schema.getIfcSchemas()) {
            HashMap<String, RenderEnginePool> map = new HashMap<String, RenderEnginePool>();
            this.pools.put(schema, map);
            for (final RenderEnginePlugin renderEnginePlugin : renderEnginePlugins) {
                map.put(renderEnginePlugin.getClass().getName(), new RenderEnginePool(nrRenderEngineProcesses, new RenderEngineFactory(){

                    @Override
                    public RenderEngine createRenderEngine() throws RenderEngineException {
                        return renderEnginePlugin.createRenderEngine(new PluginConfiguration(), schema.name());
                    }
                }));
            }
        }
    }

    public RenderEnginePool getRenderEnginePool(final Schema schema, String className) throws PluginException {
        if (this.pools.containsKey(schema)) {
            Map<String, RenderEnginePool> map = this.pools.get(schema);
            if (map.containsKey(className)) {
                return map.get(className);
            }
            final RenderEnginePlugin renderEnginePlugin = this.bimServer.getPluginManager().getRenderEnginePlugin(className, true);
            if (renderEnginePlugin == null) {
                throw new PluginException("No render engine found for className " + className);
            }
            int nrRenderEngineProcesses = this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses();
            RenderEnginePool renderEnginePool = new RenderEnginePool(nrRenderEngineProcesses, new RenderEngineFactory(){

                @Override
                public RenderEngine createRenderEngine() throws RenderEngineException {
                    return renderEnginePlugin.createRenderEngine(new PluginConfiguration(), schema.name());
                }
            });
            map.put(className, renderEnginePool);
            return renderEnginePool;
        }
        throw new PluginException("No render engine found for schema " + schema);
    }
}

