/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.schemaconverter;

import java.util.HashMap;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.schemaconverter.SchemaConverter;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaConverter
implements SchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchemaConverter.class);
    private final HashMap<IdEObject, IdEObject> converted = new HashMap();
    private IfcModelInterface source;
    private IfcModelInterface target;

    public AbstractSchemaConverter(IfcModelInterface source, IfcModelInterface target) {
        this.source = source;
        this.target = target;
    }

    protected IdEObject copy(IdEObject original) throws IfcModelInterfaceException {
        if (!((IdEObjectImpl)original).isLoadedOrLoading()) {
            return null;
        }
        if (this.converted.containsKey(original)) {
            return this.converted.get(original);
        }
        if (original.eClass().getName().equals("GeometryInfo") || original.eClass().getName().equals("GeometryData") || original.eClass().getName().equals("Vector3f")) {
            return null;
        }
        EClass eClass = (EClass)this.target.getPackageMetaData().getEPackage().getEClassifier(original.eClass().getName());
        if (eClass == null) {
            LOGGER.info("No class " + original.eClass().getName() + " in " + this.target.getPackageMetaData().getEPackage().getName());
            return null;
        }
        IdEObject newObject = (IdEObject)eClass.getEPackage().getEFactoryInstance().create(eClass);
        ((IdEObjectImpl)newObject).setOid(original.getOid());
        this.converted.put(original, newObject);
        if (newObject.eClass().getEAnnotation("wrapped") == null) {
            this.target.add(newObject.getOid(), newObject);
        }
        for (EStructuralFeature eStructuralFeature : original.eClass().getEAllStructuralFeatures()) {
            EStructuralFeature targetFeature = newObject.eClass().getEStructuralFeature(eStructuralFeature.getName());
            if (targetFeature == null) continue;
            Object get = original.eGet(eStructuralFeature);
            if (eStructuralFeature instanceof EAttribute) {
                if (get instanceof Double) {
                    EStructuralFeature doubleStringFeature = original.eClass().getEStructuralFeature("wrappedValueAsString");
                    EStructuralFeature targetDoubleStringFeature = newObject.eClass().getEStructuralFeature("wrappedValueAsString");
                    if (doubleStringFeature != null && targetDoubleStringFeature != null) {
                        Object doubleString = original.eGet(doubleStringFeature);
                        newObject.eSet(targetDoubleStringFeature, doubleString);
                        continue;
                    }
                    newObject.eSet(targetFeature, get);
                    continue;
                }
                if (eStructuralFeature.getEType() instanceof EEnum) {
                    EEnum targetEnum = (EEnum)targetFeature.getEType();
                    EEnumLiteral newLiteral = targetEnum.getEEnumLiteral(get.toString());
                    if (newLiteral == null) continue;
                    newObject.eSet(targetFeature, (Object)newLiteral.getInstance());
                    continue;
                }
                if (!(targetFeature instanceof EAttribute)) continue;
                newObject.eSet(targetFeature, get);
                continue;
            }
            if (!(eStructuralFeature instanceof EReference) || get == null) continue;
            if (eStructuralFeature.isMany()) {
                EList list = (EList)get;
                AbstractEList toList = (AbstractEList)newObject.eGet(targetFeature);
                if (toList == null) continue;
                for (Object o : list) {
                    IdEObject ref = (IdEObject)o;
                    if (!targetFeature.getEType().isInstance((Object)ref)) continue;
                    if (this.converted.containsKey(o)) {
                        toList.addUnique((Object)this.converted.get(o));
                        continue;
                    }
                    IdEObject result = this.copy((IdEObject)o);
                    if (result == null) continue;
                    toList.addUnique((Object)result);
                }
                continue;
            }
            if (targetFeature.isMany()) {
                LOGGER.info("Different multiplicity");
                continue;
            }
            if (this.converted.containsKey(get)) {
                newObject.eSet(targetFeature, (Object)this.converted.get(get));
                continue;
            }
            newObject.eSet(targetFeature, (Object)this.copy((IdEObject)get));
        }
        return newObject;
    }

    public IfcModelInterface getSource() {
        return this.source;
    }

    public IfcModelInterface getTarget() {
        return this.target;
    }
}

