/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.schemaconverter;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.tue.buildingsmart.emf.DerivedReader;
import nl.tue.buildingsmart.express.parser.SchemaLoader;
import nl.tue.buildingsmart.schema.AggregationType;
import nl.tue.buildingsmart.schema.ArrayType;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.BaseType;
import nl.tue.buildingsmart.schema.BinaryType;
import nl.tue.buildingsmart.schema.BooleanType;
import nl.tue.buildingsmart.schema.DefinedType;
import nl.tue.buildingsmart.schema.DerivedAttribute2;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.EnumerationType;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import nl.tue.buildingsmart.schema.IntegerBound;
import nl.tue.buildingsmart.schema.IntegerType;
import nl.tue.buildingsmart.schema.InverseAttribute;
import nl.tue.buildingsmart.schema.LogicalType;
import nl.tue.buildingsmart.schema.NamedType;
import nl.tue.buildingsmart.schema.NumberType;
import nl.tue.buildingsmart.schema.RealType;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import nl.tue.buildingsmart.schema.SelectType;
import nl.tue.buildingsmart.schema.SimpleType;
import nl.tue.buildingsmart.schema.StringType;
import nl.tue.buildingsmart.schema.UnderlyingType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Express2EMF {
    private static final Logger LOGGER = LoggerFactory.getLogger(Express2EMF.class);
    private final SchemaDefinition schema;
    private final EcoreFactory eFactory;
    private final EcorePackage ePackage;
    private final EPackage schemaPack;
    private final Map<EClass, Set<EClass>> directSubTypes = new HashMap<EClass, Set<EClass>>();
    private final Map<String, EDataType> simpleTypeReplacementMap = new HashMap<String, EDataType>();
    private EEnum tristate;

    public Express2EMF(File schemaFileName, String modelName, String nsUri) {
        this.schema = new SchemaLoader(schemaFileName.getAbsolutePath()).getSchema();
        this.eFactory = EcoreFactory.eINSTANCE;
        this.ePackage = EcorePackage.eINSTANCE;
        this.schemaPack = this.eFactory.createEPackage();
        try {
            new DerivedReader(schemaFileName, this.schema);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.schemaPack.setName(modelName);
        this.schemaPack.setNsPrefix("iai");
        this.schemaPack.setNsURI(nsUri);
        this.createTristate();
        this.addClasses();
        this.addSupertypes();
        this.addSimpleTypes();
        this.addDerivedTypes();
        this.addEnumerations();
        this.addHackedTypes();
        this.addSelects();
        this.addAttributes();
        this.addInverses();
        EClass ifcBooleanClass = (EClass)this.schemaPack.getEClassifier("IfcBoolean");
        ifcBooleanClass.getESuperTypes().add((Object)((EClass)this.schemaPack.getEClassifier("IfcValue")));
        this.doRealDerivedAttributes();
        this.clean();
    }

    private void addHackedTypes() {
        for (DefinedType type : this.schema.getTypes()) {
            if (type.getName().equals("IfcCompoundPlaneAngleMeasure")) continue;
            if (type.getName().equals("IfcComplexNumber")) {
                EClass ifcComplexNumber = this.getOrCreateEClass(type.getName());
                DefinedType realType = new DefinedType("Real");
                realType.setDomain((UnderlyingType)new RealType());
                EAttribute attribute = this.modifySimpleType(realType, ifcComplexNumber);
                ifcComplexNumber.getEStructuralFeature("wrappedValueAsString").setUpperBound(2);
                attribute.setUpperBound(2);
                ifcComplexNumber.getEAnnotations().add((Object)this.createWrappedAnnotation());
                continue;
            }
            if (!type.getName().equals("IfcNullStyle")) continue;
            EClassifier ifcNullStyleEnum = this.schemaPack.getEClassifier("IfcNullStyle");
            ifcNullStyleEnum.setName("IfcNullStyleEnum");
            EClass ifcNullStyleWrapper = this.getOrCreateEClass(type.getName());
            EAttribute wrappedValue = this.eFactory.createEAttribute();
            wrappedValue.setName("wrappedValue");
            wrappedValue.setEType(ifcNullStyleEnum);
            ifcNullStyleWrapper.getEAnnotations().add((Object)this.createWrappedAnnotation());
            ifcNullStyleWrapper.getEStructuralFeatures().add((Object)wrappedValue);
        }
    }

    private EAnnotation createWrappedAnnotation() {
        EAnnotation wrappedAnnotation = this.eFactory.createEAnnotation();
        wrappedAnnotation.setSource("wrapped");
        return wrappedAnnotation;
    }

    private void clean() {
        for (EClassifier eClassifier : this.schemaPack.getEClassifiers()) {
            EClass eClass;
            if (eClassifier instanceof EClass && (eClass = (EClass)eClassifier).getEAnnotation("wrapped") != null && eClass.getESuperTypes().size() != 1) continue;
        }
    }

    private void doRealDerivedAttributes() {
        for (EntityDefinition entityDefinition : this.schema.getEntities()) {
            for (DerivedAttribute2 attributeName : entityDefinition.getDerivedAttributes().values()) {
                EClass eClass = (EClass)this.schemaPack.getEClassifier(entityDefinition.getName());
                if (attributeName.getType() == null || attributeName.hasSuper() || !(attributeName.getType() instanceof DefinedType)) continue;
                EClassifier eType = this.schemaPack.getEClassifier(((DefinedType)attributeName.getType()).getName());
                boolean found = false;
                for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                    if (eSuperType.getEStructuralFeature(attributeName.getName()) == null) continue;
                    found = true;
                    break;
                }
                if (eType.getEAnnotation("wrapped") != null) {
                    if (found) continue;
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setDerived(true);
                    eAttribute.setName(attributeName.getName());
                    if (eAttribute.getName().equals("RefLatitude") || eAttribute.getName().equals("RefLongitude")) {
                        eAttribute.setUpperBound(3);
                        eAttribute.setUnique(false);
                    }
                    EClassifier type = ((EClass)eType).getEStructuralFeature("wrappedValue").getEType();
                    eAttribute.setEType(type);
                    eAttribute.setUnsettable(true);
                    eClass.getEStructuralFeatures().add((Object)eAttribute);
                    if (type != EcorePackage.eINSTANCE.getEDouble()) continue;
                    EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
                    doubleStringAttribute.setName(attributeName.getName() + "AsString");
                    doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
                    doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
                    doubleStringAttribute.setUnsettable(true);
                    doubleStringAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                    eClass.getEStructuralFeatures().add((Object)doubleStringAttribute);
                    continue;
                }
                if (found) continue;
                EReference eReference = this.eFactory.createEReference();
                eReference.setName(attributeName.getName());
                eReference.setDerived(true);
                eReference.setUnsettable(true);
                eReference.setEType(eType);
                eClass.getEStructuralFeatures().add((Object)eReference);
            }
        }
    }

    private EAnnotation createHiddenAnnotation() {
        EAnnotation hiddenAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        hiddenAnnotation.setSource("hidden");
        return hiddenAnnotation;
    }

    private EAnnotation createAsStringAnnotation() {
        EAnnotation asStringAnnotation = this.eFactory.createEAnnotation();
        asStringAnnotation.setSource("asstring");
        return asStringAnnotation;
    }

    private void createTristate() {
        this.tristate = this.eFactory.createEEnum();
        this.tristate.setName("Tristate");
        EEnumLiteral trueLiteral = this.eFactory.createEEnumLiteral();
        trueLiteral.setName("TRUE");
        trueLiteral.setValue(0);
        EEnumLiteral falseLiteral = this.eFactory.createEEnumLiteral();
        falseLiteral.setName("FALSE");
        falseLiteral.setValue(1);
        EEnumLiteral undefinedLiteral = this.eFactory.createEEnumLiteral();
        undefinedLiteral.setName("UNDEFINED");
        undefinedLiteral.setValue(2);
        this.tristate.getELiterals().add((Object)trueLiteral);
        this.tristate.getELiterals().add((Object)falseLiteral);
        this.tristate.getELiterals().add((Object)undefinedLiteral);
        this.schemaPack.getEClassifiers().add((Object)this.tristate);
    }

    private void addInverses() {
        for (EntityDefinition ent : this.schema.getEntities()) {
            Iterator attribIter = ent.getAttributes(false).iterator();
            EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
            while (attribIter.hasNext()) {
                Attribute attrib = (Attribute)attribIter.next();
                if (!(attrib instanceof InverseAttribute)) continue;
                this.addInverseAttribute(attrib, cls);
            }
        }
    }

    private void addInverseAttribute(Attribute attrib, EClass cls) {
        InverseAttribute inverseAttribute = (InverseAttribute)attrib;
        EReference eRef = this.eFactory.createEReference();
        eRef.setUnsettable(true);
        eRef.getEAnnotations().add((Object)this.createInverseAnnotation());
        eRef.setName(attrib.getName());
        if (inverseAttribute.getMax_cardinality() != null) {
            IntegerBound max_cardinality = (IntegerBound)inverseAttribute.getMax_cardinality();
            if (max_cardinality.getBound_value() == -1) {
                eRef.setUpperBound(max_cardinality.getBound_value());
            } else {
                eRef.setUpperBound(max_cardinality.getBound_value() + 1);
            }
        }
        String type = inverseAttribute.getDomain().getName();
        EClass classifier = (EClass)this.schemaPack.getEClassifier(type);
        eRef.setEType((EClassifier)classifier);
        String reverseName = inverseAttribute.getInverted_attr().getName();
        EReference reference = (EReference)classifier.getEStructuralFeature(reverseName);
        reference.getEAnnotations().add((Object)this.createInverseAnnotation());
        if (eRef.getEType() == classifier && reference.getEType() == cls) {
            if (eRef.isMany()) {
                eRef.setUnique(true);
            }
            if (reference.isMany()) {
                reference.setUnique(true);
            }
            reference.setEOpposite(eRef);
            eRef.setEOpposite(reference);
        } else {
            LOGGER.info("Inverse mismatch");
            LOGGER.info(classifier.getName() + "." + reference.getName() + " => " + cls.getName() + "." + eRef.getName());
        }
        cls.getEStructuralFeatures().add((Object)eRef);
    }

    private EAnnotation createInverseAnnotation() {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource("inverse");
        return eAnnotation;
    }

    private void addAttributes() {
        for (EntityDefinition ent : this.schema.getEntities()) {
            for (Attribute attrib : ent.getAttributes(false)) {
                if (!(attrib instanceof ExplicitAttribute)) continue;
                this.processAttribute(ent, attrib);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAttribute(EntityDefinition ent, Attribute attrib) {
        ExplicitAttribute expAttrib = (ExplicitAttribute)attrib;
        BaseType domain = expAttrib.getDomain();
        if (ent.getName().equals("IfcRelConnectsPathElements") && (attrib.getName().equals("RelatingPriorities") || attrib.getName().equals("RelatedPriorities"))) {
            EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
            EAttribute eAttribute = this.eFactory.createEAttribute();
            eAttribute.setName(attrib.getName());
            eAttribute.setUpperBound(-1);
            eAttribute.setUnique(false);
            eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
            eAttribute.setUnsettable(expAttrib.isOptional());
            cls.getEStructuralFeatures().add((Object)eAttribute);
            return;
        }
        if (domain instanceof NamedType) {
            NamedType nt = (NamedType)domain;
            if (nt instanceof EnumerationType) {
                EAttribute enumAttrib = this.eFactory.createEAttribute();
                enumAttrib.setUnsettable(expAttrib.isOptional());
                enumAttrib.setName(attrib.getName());
                EClassifier eType = this.schemaPack.getEClassifier(nt.getName());
                enumAttrib.setEType(eType);
                EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
                cls.getEStructuralFeatures().add((Object)enumAttrib);
                return;
            } else {
                EClass eType = (EClass)this.schemaPack.getEClassifier(nt.getName());
                EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
                boolean wrapped = this.superTypeIsWrapped(eType);
                if (wrapped) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    eAttribute.setName(attrib.getName());
                    if (eAttribute.getName().equals("RefLatitude") || eAttribute.getName().equals("RefLongitude")) {
                        eAttribute.setUpperBound(3);
                        eAttribute.setUnique(false);
                    }
                    EClassifier type = eType.getEStructuralFeature("wrappedValue").getEType();
                    eAttribute.setEType(type);
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                    if (type != EcorePackage.eINSTANCE.getEDouble()) return;
                    EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
                    doubleStringAttribute.setName(attrib.getName() + "AsString");
                    doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
                    doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
                    doubleStringAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                    doubleStringAttribute.setUnsettable(expAttrib.isOptional());
                    cls.getEStructuralFeatures().add((Object)doubleStringAttribute);
                    return;
                } else {
                    EReference eRef = this.eFactory.createEReference();
                    eRef.setName(attrib.getName());
                    eRef.setUnsettable(expAttrib.isOptional());
                    eRef.setEType((EClassifier)eType);
                    cls.getEStructuralFeatures().add((Object)eRef);
                }
            }
            return;
        } else {
            if (domain instanceof AggregationType) {
                BaseType bt = ((AggregationType)domain).getElement_type();
                EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
                if (bt instanceof NamedType) {
                    NamedType nt = (NamedType)bt;
                    EClassifier eType = this.schemaPack.getEClassifier(nt.getName());
                    if (this.superTypeIsWrapped((EClass)eType)) {
                        EAttribute eAttribute = this.eFactory.createEAttribute();
                        eAttribute.setName(attrib.getName());
                        if (eAttribute.getName().equals("RefLatitude") || eAttribute.getName().equals("RefLongitude")) {
                            eAttribute.setUpperBound(3);
                        } else {
                            eAttribute.setUpperBound(-1);
                        }
                        EClassifier type = ((EClass)eType).getEStructuralFeature("wrappedValue").getEType();
                        eAttribute.setEType(type);
                        eAttribute.setUnsettable(expAttrib.isOptional());
                        eAttribute.setUnique(false);
                        cls.getEStructuralFeatures().add((Object)eAttribute);
                        if (type == EcorePackage.eINSTANCE.getEDouble()) {
                            EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
                            doubleStringAttribute.setName(attrib.getName() + "AsString");
                            doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
                            doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
                            doubleStringAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                            doubleStringAttribute.setUpperBound(-1);
                            doubleStringAttribute.setUnsettable(expAttrib.isOptional());
                            doubleStringAttribute.setUpperBound(eAttribute.getUpperBound());
                            doubleStringAttribute.setUnique(false);
                            cls.getEStructuralFeatures().add((Object)doubleStringAttribute);
                        }
                    } else if (eType == EcorePackage.eINSTANCE.getEDouble()) {
                        EAttribute eAttribute = this.eFactory.createEAttribute();
                        eAttribute.setName(attrib.getName());
                        eAttribute.setUnsettable(expAttrib.isOptional());
                        eAttribute.setUnique(false);
                        eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEAttribute());
                        cls.getEStructuralFeatures().add((Object)eAttribute);
                        EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
                        doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
                        doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
                        doubleStringAttribute.setName(attrib.getName() + "AsString");
                        doubleStringAttribute.setUpperBound(-1);
                        doubleStringAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                        doubleStringAttribute.setUnsettable(expAttrib.isOptional());
                        doubleStringAttribute.setUpperBound(eAttribute.getUpperBound());
                        doubleStringAttribute.setUnique(false);
                        cls.getEStructuralFeatures().add((Object)doubleStringAttribute);
                    } else {
                        EReference eRef = this.eFactory.createEReference();
                        eRef.setUpperBound(-1);
                        eRef.setName(attrib.getName());
                        eRef.setUnsettable(expAttrib.isOptional());
                        eRef.setEType(eType);
                        eRef.setUnique(false);
                        cls.getEStructuralFeatures().add((Object)eRef);
                    }
                } else if (bt instanceof RealType) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    eAttribute.setName(attrib.getName());
                    eAttribute.setUpperBound(-1);
                    eAttribute.setUnique(false);
                    eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEDouble());
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                    EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
                    doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
                    doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
                    doubleStringAttribute.setName(attrib.getName() + "AsString");
                    doubleStringAttribute.setUpperBound(-1);
                    doubleStringAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                    doubleStringAttribute.setUnsettable(expAttrib.isOptional());
                    doubleStringAttribute.setUpperBound(eAttribute.getUpperBound());
                    doubleStringAttribute.setUnique(false);
                    cls.getEStructuralFeatures().add((Object)doubleStringAttribute);
                } else if (bt instanceof IntegerType) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setName(attrib.getName());
                    eAttribute.setUpperBound(-1);
                    eAttribute.setUnique(false);
                    eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                } else if (bt instanceof NumberType) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setName(attrib.getName());
                    eAttribute.setUpperBound(-1);
                    eAttribute.setUnique(false);
                    eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                } else if (bt instanceof LogicalType) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setName(attrib.getName());
                    eAttribute.setUpperBound(-1);
                    eAttribute.setUnique(false);
                    eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                } else if (bt instanceof BinaryType) {
                    EAttribute eAttribute = this.eFactory.createEAttribute();
                    eAttribute.setUnsettable(expAttrib.isOptional());
                    eAttribute.setUpperBound(-1);
                    eAttribute.setName(attrib.getName());
                    eAttribute.setUnique(false);
                    eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEByteArray());
                    cls.getEStructuralFeatures().add((Object)eAttribute);
                } else if (bt == null) {
                    this.addTwoDimensionalArray(ent.getName(), attrib.getName());
                }
                if (!(domain instanceof ArrayType)) return;
            }
            EClass cls = (EClass)this.schemaPack.getEClassifier(ent.getName());
            if (domain == null) {
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)this.tristate);
                cls.getEStructuralFeatures().add((Object)eAttribute);
                return;
            } else if (domain instanceof IntegerType) {
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
                cls.getEStructuralFeatures().add((Object)eAttribute);
                return;
            } else if (domain instanceof LogicalType) {
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
                cls.getEStructuralFeatures().add((Object)eAttribute);
                return;
            } else if (domain instanceof RealType) {
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEDouble());
                cls.getEStructuralFeatures().add((Object)eAttribute);
                EAttribute eAttributeAsString = this.eFactory.createEAttribute();
                eAttributeAsString.getEAnnotations().add((Object)this.createAsStringAnnotation());
                eAttributeAsString.getEAnnotations().add((Object)this.createHiddenAnnotation());
                eAttributeAsString.setUnsettable(expAttrib.isOptional());
                eAttributeAsString.setName(attrib.getName() + "AsString");
                eAttributeAsString.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                cls.getEStructuralFeatures().add((Object)eAttributeAsString);
                return;
            } else if (domain instanceof StringType) {
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                cls.getEStructuralFeatures().add((Object)eAttribute);
                return;
            } else {
                if (!(domain instanceof BinaryType)) throw new RuntimeException("Unknown type: " + domain);
                EAttribute eAttribute = this.eFactory.createEAttribute();
                eAttribute.setUnsettable(expAttrib.isOptional());
                eAttribute.setName(attrib.getName());
                eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEByteArray());
                cls.getEStructuralFeatures().add((Object)eAttribute);
            }
        }
        return;
    }

    private void addTwoDimensionalArray(String entityName, String attribName) {
        EClassifier finalType = null;
        if (entityName.equals("IfcBSplineSurface") && attribName.equals("ControlPointsList")) {
            finalType = this.schemaPack.getEClassifier("IfcCartesianPoint");
        } else if (entityName.equals("IfcCartesianPointList3D") && attribName.equals("CoordList")) {
            finalType = this.schemaPack.getEClassifier("IfcLengthMeasure");
        } else if (entityName.equals("IfcColourRgbList") && attribName.equals("ColourList")) {
            finalType = this.schemaPack.getEClassifier("IfcNormalisedRatioMeasure");
        } else if (entityName.equals("IfcIndexedTriangleTextureMap") && attribName.equals("TexCoordIndex")) {
            finalType = EcorePackage.eINSTANCE.getEInt();
        } else if (entityName.equals("IfcRationalBSplineSurfaceWithKnots") && attribName.equals("WeightsData")) {
            finalType = EcorePackage.eINSTANCE.getEDouble();
        } else if (entityName.equals("IfcStructuralLoadConfiguration") && attribName.equals("Locations")) {
            finalType = this.schemaPack.getEClassifier("IfcLengthMeasure");
        } else if (entityName.equals("IfcTessellatedFaceSet") && attribName.equals("Normals")) {
            finalType = this.schemaPack.getEClassifier("IfcParameterValue");
        } else if (entityName.equals("IfcTextureVertexList") && attribName.equals("TexCoordsList")) {
            finalType = this.schemaPack.getEClassifier("IfcParameterValue");
        } else if (entityName.equals("IfcTriangulatedFaceSet") && attribName.equals("CoordIndex")) {
            finalType = EcorePackage.eINSTANCE.getEInt();
        } else if (entityName.equals("IfcTriangulatedFaceSet") && attribName.equals("NormalIndex")) {
            finalType = EcorePackage.eINSTANCE.getEInt();
        } else {
            throw new RuntimeException("Unimplemented " + entityName + "." + attribName);
        }
        EClass containerClass = (EClass)this.schemaPack.getEClassifier("ListOf" + finalType.getName());
        if (containerClass == null) {
            containerClass = EcoreFactory.eINSTANCE.createEClass();
            containerClass.setName("ListOf" + finalType.getName());
            if (finalType.getEPackage() == EcorePackage.eINSTANCE) {
                EAttribute finalAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                finalAttribute.setName("List");
                finalAttribute.setEType(finalType);
                finalAttribute.setUpperBound(-1);
                containerClass.getEAttributes().add((Object)finalAttribute);
            } else {
                EReference finalReference = EcoreFactory.eINSTANCE.createEReference();
                finalReference.setName("List");
                finalReference.setEType(finalType);
                finalReference.setUpperBound(-1);
                containerClass.getEReferences().add((Object)finalReference);
            }
            this.schemaPack.getEClassifiers().add((Object)containerClass);
        }
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.getEAnnotations().add((Object)this.createTwoDimensionalArrayAnnotation());
        eReference.setName(attribName);
        eReference.setUpperBound(-1);
        eReference.setEType((EClassifier)containerClass);
        EClass cls = (EClass)this.schemaPack.getEClassifier(entityName);
        cls.getEStructuralFeatures().add((Object)eReference);
    }

    private EAnnotation createTwoDimensionalArrayAnnotation() {
        EAnnotation asStringAnnotation = this.eFactory.createEAnnotation();
        asStringAnnotation.setSource("twodimensionalarray");
        return asStringAnnotation;
    }

    private boolean superTypeIsWrapped(EClass eType) {
        if (eType.getEAnnotation("wrapped") != null) {
            return true;
        }
        for (EClass superClass : eType.getESuperTypes()) {
            if (!this.superTypeIsWrapped(superClass)) continue;
            return true;
        }
        return false;
    }

    private void addClasses() {
        Iterator entIter = this.schema.getEntities().iterator();
        while (entIter.hasNext()) {
            this.getOrCreateEClass(((EntityDefinition)entIter.next()).getName());
        }
    }

    private void addSupertypes() {
        for (EntityDefinition ent : this.schema.getEntities()) {
            if (ent.getSupertypes().size() <= 0) continue;
            EClass cls = this.getOrCreateEClass(ent.getName());
            if (ent.getSupertypes().size() <= 0) continue;
            EClass parent = this.getOrCreateEClass(((EntityDefinition)ent.getSupertypes().get(0)).getName());
            if (!this.directSubTypes.containsKey(parent)) {
                this.directSubTypes.put(parent, new HashSet());
            }
            this.directSubTypes.get(parent).add(cls);
            cls.getESuperTypes().add((Object)parent);
        }
    }

    private void addSelects() {
        EClass choice;
        EClass selectType;
        for (DefinedType type : this.schema.getTypes()) {
            if (!(type instanceof SelectType)) continue;
            selectType = this.getOrCreateEClass(type.getName());
            selectType.setInterface(true);
            selectType.setAbstract(true);
            for (NamedType nt : ((SelectType)type).getSelections()) {
                EClass choice2;
                if (nt instanceof EntityDefinition) {
                    choice = this.getOrCreateEClass(nt.getName());
                    choice.getESuperTypes().add((Object)selectType);
                    continue;
                }
                if (!(nt instanceof DefinedType)) continue;
                UnderlyingType domain = ((DefinedType)nt).getDomain();
                if (domain instanceof RealType || domain instanceof StringType || domain instanceof IntegerType || domain instanceof NumberType || domain instanceof LogicalType) {
                    choice2 = this.getOrCreateEClass(nt.getName());
                    choice2.getESuperTypes().add((Object)selectType);
                    continue;
                }
                if (domain instanceof DefinedType) {
                    DefinedType dt2 = (DefinedType)domain;
                    if (!(dt2.getDomain() instanceof RealType)) continue;
                    EClass choice3 = this.getOrCreateEClass(nt.getName());
                    choice3.getESuperTypes().add((Object)selectType);
                    continue;
                }
                if (nt instanceof SelectType) continue;
                if (nt.getName().equals("IfcComplexNumber") || nt.getName().equals("IfcCompoundPlaneAngleMeasure") || nt.getName().equals("IfcBoolean") || nt.getName().equals("IfcNullStyle")) {
                    choice2 = this.getOrCreateEClass(nt.getName());
                    choice2.getESuperTypes().add((Object)selectType);
                    continue;
                }
                System.out.println("The domain is null for " + selectType.getName() + " " + nt.getName());
            }
        }
        for (DefinedType type : this.schema.getTypes()) {
            if (!(type instanceof SelectType)) continue;
            selectType = (EClass)this.schemaPack.getEClassifier(type.getName());
            for (NamedType nt : ((SelectType)type).getSelections()) {
                if (!(nt instanceof SelectType)) continue;
                choice = this.getOrCreateEClass(nt.getName());
                choice.getESuperTypes().add((Object)selectType);
            }
        }
    }

    private EAttribute modifySimpleType(DefinedType type, EClass testType) {
        if (this.directSubTypes.containsKey(testType)) {
            for (EClass subType : this.directSubTypes.get(testType)) {
                this.x(type, subType);
            }
        }
        EAttribute wrapperAttrib = this.x(type, testType);
        return wrapperAttrib;
    }

    private EAttribute x(DefinedType type, EClass testType) {
        EAttribute wrapperAttrib = this.eFactory.createEAttribute();
        wrapperAttrib.setName("wrappedValue");
        if (type.getDomain() instanceof IntegerType) {
            wrapperAttrib.setEType((EClassifier)this.ePackage.getEInt());
        } else if (type.getDomain() instanceof RealType) {
            wrapperAttrib.setEType((EClassifier)this.ePackage.getEDouble());
        } else if (type.getDomain() instanceof StringType) {
            wrapperAttrib.setEType((EClassifier)this.ePackage.getEString());
        } else if (type.getDomain() instanceof BooleanType) {
            wrapperAttrib.setEType(this.schemaPack.getEClassifier("Tristate"));
        } else if (type.getDomain() instanceof NumberType) {
            wrapperAttrib.setEType((EClassifier)this.ePackage.getEDouble());
        } else if (type.getDomain() instanceof LogicalType) {
            wrapperAttrib.setEType(this.schemaPack.getEClassifier("Tristate"));
        }
        wrapperAttrib.setUnsettable(true);
        testType.getEStructuralFeatures().add((Object)wrapperAttrib);
        if (wrapperAttrib.getEType() == this.ePackage.getEDouble()) {
            EAttribute doubleStringAttribute = this.eFactory.createEAttribute();
            doubleStringAttribute.setEType((EClassifier)this.ePackage.getEString());
            doubleStringAttribute.setName("wrappedValueAsString");
            doubleStringAttribute.getEAnnotations().add((Object)this.createAsStringAnnotation());
            doubleStringAttribute.getEAnnotations().add((Object)this.createHiddenAnnotation());
            doubleStringAttribute.setUnsettable(true);
            testType.getEStructuralFeatures().add((Object)doubleStringAttribute);
        }
        return wrapperAttrib;
    }

    private void addSimpleTypes() {
        for (DefinedType type : this.schema.getTypes()) {
            if (!(type.getDomain() instanceof SimpleType)) continue;
            EClass testType = this.getOrCreateEClass(type.getName());
            testType.getEAnnotations().add((Object)this.createWrappedAnnotation());
            this.modifySimpleType(type, testType);
        }
    }

    private EClass getOrCreateEClass(String name) {
        EClassifier eClassifier = this.schemaPack.getEClassifier(name);
        if (eClassifier == null) {
            eClassifier = this.eFactory.createEClass();
            eClassifier.setName(name);
            this.schemaPack.getEClassifiers().add((Object)eClassifier);
        }
        return (EClass)eClassifier;
    }

    private void addDerivedTypes() {
        for (DefinedType type : this.schema.getTypes()) {
            EClassifier classifier;
            DefinedType domain;
            EClass testType;
            if (type.getName().equalsIgnoreCase("IfcCompoundPlaneAngleMeasure")) {
                testType = this.getOrCreateEClass(type.getName());
                DefinedType type2 = new DefinedType("Integer");
                type2.setDomain((UnderlyingType)new IntegerType());
                this.modifySimpleType(type2, testType);
                testType.getEAnnotations().add((Object)this.createWrappedAnnotation());
                continue;
            }
            if (!(type.getDomain() instanceof DefinedType)) continue;
            if (this.schemaPack.getEClassifier(type.getName()) != null) {
                testType = (EClass)this.schemaPack.getEClassifier(type.getName());
                domain = (DefinedType)type.getDomain();
                classifier = this.schemaPack.getEClassifier(domain.getName());
                testType.getESuperTypes().add((Object)((EClass)classifier));
                testType.setInstanceClass(classifier.getInstanceClass());
                continue;
            }
            testType = this.getOrCreateEClass(type.getName());
            domain = (DefinedType)type.getDomain();
            if (this.simpleTypeReplacementMap.containsKey(domain.getName())) {
                this.simpleTypeReplacementMap.put(type.getName(), this.simpleTypeReplacementMap.get(domain.getName()));
                continue;
            }
            classifier = this.getOrCreateEClass(domain.getName());
            testType.getESuperTypes().add((Object)classifier);
            if (classifier.getEAnnotation("wrapped") != null) {
                testType.getEAnnotations().add((Object)this.createWrappedAnnotation());
            }
            testType.setInstanceClass(classifier.getInstanceClass());
        }
    }

    private void addEnumerations() {
        for (DefinedType type : this.schema.getTypes()) {
            if (!(type instanceof EnumerationType)) continue;
            EEnum enumeration = this.eFactory.createEEnum();
            enumeration.setName(type.getName());
            EEnumLiteral nullValue = this.eFactory.createEEnumLiteral();
            nullValue.setName("NULL");
            nullValue.setLiteral("NULL");
            nullValue.setValue(0);
            enumeration.getELiterals().add((Object)nullValue);
            int counter = 1;
            for (String stringVal : ((EnumerationType)type).getElements()) {
                if (stringVal.equals("NULL")) continue;
                EEnumLiteral value = this.eFactory.createEEnumLiteral();
                value.setName(stringVal);
                value.setLiteral(stringVal);
                value.setValue(counter);
                ++counter;
                enumeration.getELiterals().add((Object)value);
            }
            this.schemaPack.getEClassifiers().add((Object)enumeration);
        }
    }

    public void writeEMF(String fileName) {
        ResourceSetImpl metaResourceSet = new ResourceSetImpl();
        metaResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMLResourceFactoryImpl());
        URI resUri = URI.createURI((String)fileName);
        Resource metaResource = metaResourceSet.createResource(resUri);
        metaResource.getContents().add((Object)this.schemaPack);
        try {
            metaResource.save(null);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

