/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.schemaconverter;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.Schema;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.schemaconverter.AbstractSchemaConverter;
import org.bimserver.schemaconverter.SchemaConverter;
import org.bimserver.schemaconverter.SchemaConverterException;

public class Ifc4ToIfcIfc2x3tc1Converter
extends AbstractSchemaConverter
implements SchemaConverter {
    public Ifc4ToIfcIfc2x3tc1Converter(IfcModelInterface source, IfcModelInterface target) {
        super(source, target);
    }

    @Override
    public void convert() throws SchemaConverterException, IfcModelInterfaceException {
        if (this.getSource().getPackageMetaData().getEPackage() != Ifc4Package.eINSTANCE) {
            throw new SchemaConverterException("Source model should be Ifc4");
        }
        if (this.getTarget().getPackageMetaData().getEPackage() != Ifc2x3tc1Package.eINSTANCE) {
            throw new SchemaConverterException("Target model should be Ifc2x3tc1");
        }
        for (IdEObject idEObject : this.getSource().getValues()) {
            this.copy(idEObject);
        }
    }

    @Override
    public Schema getSourceSchema() {
        return Schema.IFC2X3TC1;
    }

    @Override
    public Schema getTargetSchema() {
        return Schema.IFC4;
    }
}

