/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.schemaconverter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.Schema;
import org.bimserver.schemaconverter.SchemaConverter;
import org.bimserver.schemaconverter.SchemaConverterFactory;
import org.bimserver.schemaconverter.SchemaKey;

public class SchemaConverterManager {
    private final Map<SchemaKey, SchemaConverterFactory> converters = new HashMap<SchemaKey, SchemaConverterFactory>();

    public void registerConverter(SchemaConverterFactory schemaConverterFactory) {
        this.converters.put(new SchemaKey(schemaConverterFactory.getSourceSchema(), schemaConverterFactory.getTargetSchema()), schemaConverterFactory);
    }

    public SchemaConverterFactory getSchemaConverterFactory(Schema source, Schema target) {
        return this.converters.get(new SchemaKey(source, target));
    }

    public SchemaConverter getSchemaConverter(Schema source, Schema target, IfcModelInterface sourceModel, IfcModelInterface targetModel) {
        SchemaConverterFactory factory = this.getSchemaConverterFactory(source, target);
        return factory.create(sourceModel, targetModel);
    }

    public Set<Schema> getSchemaTargets(Schema source) {
        HashSet<Schema> result = new HashSet<Schema>();
        for (SchemaConverterFactory factory : this.converters.values()) {
            if (factory.getSourceSchema() != source) continue;
            result.add(factory.getTargetSchema());
        }
        return result;
    }
}

