/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.QueryInterface;
import org.bimserver.emf.Schema;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.interfaces.objects.SModelCheckerPluginDescriptor;
import org.bimserver.interfaces.objects.SModelComparePluginDescriptor;
import org.bimserver.interfaces.objects.SModelMergerPluginDescriptor;
import org.bimserver.interfaces.objects.SQueryEnginePluginDescriptor;
import org.bimserver.interfaces.objects.SRenderEnginePluginDescriptor;
import org.bimserver.interfaces.objects.SSerializerPluginDescriptor;
import org.bimserver.interfaces.objects.SServicePluginDescriptor;
import org.bimserver.interfaces.objects.SWebModulePluginDescriptor;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.models.store.GeoTag;
import org.bimserver.models.store.MessagingSerializerPluginConfiguration;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.plugins.modelcompare.ModelComparePlugin;
import org.bimserver.plugins.modelmerger.ModelMergerPlugin;
import org.bimserver.plugins.queryengine.QueryEnginePlugin;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.serializers.MessagingSerializer;
import org.bimserver.plugins.serializers.MessagingSerializerPlugin;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.Serializer;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.schemaconverter.SchemaConverter;
import org.bimserver.schemaconverter.SchemaConverterException;
import org.bimserver.schemaconverter.SchemaConverterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerFactory.class);
    private PluginManager pluginManager;
    private BimDatabase bimDatabase;
    private BimServer bimServer;

    public void init(PluginManager pluginManager, BimDatabase bimDatabase, BimServer bimServer) {
        this.pluginManager = pluginManager;
        this.bimDatabase = bimDatabase;
        this.bimServer = bimServer;
    }

    public List<SSerializerPluginDescriptor> getAllSerializerPluginDescriptors() {
        ArrayList<SSerializerPluginDescriptor> descriptors = new ArrayList<SSerializerPluginDescriptor>();
        for (SerializerPlugin serializerPlugin : this.pluginManager.getAllSerializerPlugins(true).values()) {
            descriptors.add(this.makeSerializerDescriptor(serializerPlugin));
        }
        return descriptors;
    }

    public List<SWebModulePluginDescriptor> getAllWebModulePluginDescriptors() {
        ArrayList<SWebModulePluginDescriptor> descriptors = new ArrayList<SWebModulePluginDescriptor>();
        for (WebModulePlugin webModulePlugin : this.pluginManager.getAllWebPlugins(true).values()) {
            descriptors.add(this.makeWebModuleDescriptor(webModulePlugin));
        }
        return descriptors;
    }

    public List<SServicePluginDescriptor> getAllServicePluginDescriptors() {
        ArrayList<SServicePluginDescriptor> descriptors = new ArrayList<SServicePluginDescriptor>();
        for (ServicePlugin servicePlugin : this.pluginManager.getAllServicePlugins(true).values()) {
            SServicePluginDescriptor descriptor = new SServicePluginDescriptor();
            descriptor.setPluginClassName(servicePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer create(Project project, String username, IfcModelInterface model, RenderEnginePlugin renderEnginePlugin, DownloadParameters downloadParameters) throws SerializerException {
        block16: {
            try (DatabaseSession session = this.bimDatabase.createSession();){
                SerializerPlugin serializerPlugin;
                SerializerPluginConfiguration serializerPluginConfiguration = (SerializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getSerializerPluginConfiguration(), downloadParameters.getSerializerOid(), (QueryInterface)OldQuery.getDefault());
                if (serializerPluginConfiguration == null || (serializerPlugin = (SerializerPlugin)this.pluginManager.getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true)) == null) break block16;
                ObjectType settings = serializerPluginConfiguration.getSettings();
                Serializer serializer = serializerPlugin.createSerializer(new PluginConfiguration(settings));
                if (!serializerPlugin.getSupportedSchemas().contains(model.getPackageMetaData().getSchema())) {
                    SchemaConverterFactory converterFactory = null;
                    for (Schema schema : serializerPlugin.getSupportedSchemas()) {
                        converterFactory = this.bimServer.getSchemaConverterManager().getSchemaConverterFactory(model.getPackageMetaData().getSchema(), schema);
                        if (converterFactory == null) continue;
                        break;
                    }
                    if (converterFactory == null) {
                        throw new SerializerException("No usable converter found for schema " + model.getPackageMetaData().getSchema() + " for serializer " + serializerPlugin.getClass().getName());
                    }
                    try {
                        BasicIfcModel targetModel = new BasicIfcModel(this.bimServer.getMetaDataManager().getPackageMetaData(converterFactory.getTargetSchema().getEPackageName()), new HashMap(), (int)model.size());
                        SchemaConverter converter = converterFactory.create(model, (IfcModelInterface)targetModel);
                        converter.convert();
                        model = targetModel;
                    }
                    catch (SchemaConverterException e) {
                        throw new SerializerException((Throwable)e);
                    }
                    catch (IfcModelInterfaceException e) {
                        throw new SerializerException((Throwable)e);
                    }
                }
                if (serializer == null) break block16;
                try {
                    ProjectInfo projectInfo = new ProjectInfo();
                    projectInfo.setName(project.getName());
                    projectInfo.setDescription(project.getDescription());
                    GeoTag geoTag = project.getGeoTag();
                    if (geoTag != null && geoTag.getEnabled().booleanValue()) {
                        projectInfo.setX(geoTag.getX().doubleValue());
                        projectInfo.setY(geoTag.getY().doubleValue());
                        projectInfo.setZ(geoTag.getZ().doubleValue());
                        projectInfo.setDirectionAngle(geoTag.getDirectionAngle().doubleValue());
                    } else {
                        projectInfo.setX(4.89);
                        projectInfo.setY(52.37);
                    }
                    projectInfo.setAuthorName(username);
                    serializer.init(model, projectInfo, (PluginManagerInterface)this.pluginManager, model.getPackageMetaData(), true);
                    Serializer serializer2 = serializer;
                    return serializer2;
                }
                catch (NullPointerException e) {
                    try {
                        LOGGER.error("", (Throwable)e);
                    }
                    catch (BimserverDatabaseException e2) {
                        LOGGER.error("", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingSerializer createMessagingSerializer(String username, IfcModelInterface model, DownloadParameters downloadParameters) throws SerializerException {
        block8: {
            try (DatabaseSession session = this.bimDatabase.createSession();){
                ObjectType settings;
                MessagingSerializer serializer;
                MessagingSerializerPlugin serializerPlugin;
                MessagingSerializerPluginConfiguration serializerPluginConfiguration = (MessagingSerializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getMessagingSerializerPluginConfiguration(), downloadParameters.getSerializerOid(), (QueryInterface)OldQuery.getDefault());
                if (serializerPluginConfiguration == null || (serializerPlugin = (MessagingSerializerPlugin)this.pluginManager.getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true)) == null || (serializer = serializerPlugin.createSerializer(new PluginConfiguration(settings = serializerPluginConfiguration.getSettings()))) == null) break block8;
                try {
                    serializer.init(model, null, (PluginManagerInterface)this.pluginManager, model.getPackageMetaData(), true);
                    MessagingSerializer messagingSerializer = serializer;
                    return messagingSerializer;
                }
                catch (NullPointerException e) {
                    try {
                        LOGGER.error("", (Throwable)e);
                    }
                    catch (BimserverDatabaseException e2) {
                        LOGGER.error("", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }

    public SSerializerPluginDescriptor getSerializerPluginDescriptor(String type) {
        for (SerializerPlugin serializerPlugin : this.pluginManager.getAllSerializerPlugins(true).values()) {
            if (!serializerPlugin.getClass().getName().equals(type)) continue;
            return this.makeSerializerDescriptor(serializerPlugin);
        }
        return null;
    }

    private SSerializerPluginDescriptor makeSerializerDescriptor(SerializerPlugin serializerPlugin) {
        SSerializerPluginDescriptor descriptor = new SSerializerPluginDescriptor();
        descriptor.setDefaultName(serializerPlugin.getDefaultName());
        descriptor.setPluginClassName(serializerPlugin.getClass().getName());
        return descriptor;
    }

    private SWebModulePluginDescriptor makeWebModuleDescriptor(WebModulePlugin webModulePlugin) {
        SWebModulePluginDescriptor descriptor = new SWebModulePluginDescriptor();
        descriptor.setDefaultName(webModulePlugin.getDefaultName());
        descriptor.setPluginClassName(webModulePlugin.getClass().getName());
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtension(Long serializerOid) {
        try (DatabaseSession session = this.bimDatabase.createSession();){
            SerializerPluginConfiguration found = (SerializerPluginConfiguration)session.get(StorePackage.eINSTANCE.getSerializerPluginConfiguration(), (long)serializerOid, (QueryInterface)OldQuery.getDefault());
            if (found != null) {
                String string = new PluginConfiguration(found.getSettings()).getString("Extension");
                return string;
            }
        }
        return null;
    }

    public List<SRenderEnginePluginDescriptor> getAllRenderEnginePluginDescriptors() {
        ArrayList<SRenderEnginePluginDescriptor> descriptors = new ArrayList<SRenderEnginePluginDescriptor>();
        for (RenderEnginePlugin renderEnginePlugin : this.pluginManager.getAllRenderEnginePlugins(true).values()) {
            SRenderEnginePluginDescriptor descriptor = new SRenderEnginePluginDescriptor();
            descriptor.setDefaultName(renderEnginePlugin.getDefaultName());
            descriptor.setPluginClassName(renderEnginePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<SQueryEnginePluginDescriptor> getAllQueryEnginePluginDescriptors() {
        ArrayList<SQueryEnginePluginDescriptor> descriptors = new ArrayList<SQueryEnginePluginDescriptor>();
        for (QueryEnginePlugin queryEnginePlugin : this.pluginManager.getAllQueryEnginePlugins(true).values()) {
            SQueryEnginePluginDescriptor descriptor = new SQueryEnginePluginDescriptor();
            descriptor.setDefaultName(queryEnginePlugin.getDefaultName());
            descriptor.setPluginClassName(queryEnginePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<SModelMergerPluginDescriptor> getAllModelMergerPluginDescriptors() {
        ArrayList<SModelMergerPluginDescriptor> descriptors = new ArrayList<SModelMergerPluginDescriptor>();
        for (ModelMergerPlugin queryEnginePlugin : this.pluginManager.getAllModelMergerPlugins(true).values()) {
            SModelMergerPluginDescriptor descriptor = new SModelMergerPluginDescriptor();
            descriptor.setDefaultName(queryEnginePlugin.getDefaultName());
            descriptor.setPluginClassName(queryEnginePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<SModelComparePluginDescriptor> getAllModelComparePluginDescriptors() {
        ArrayList<SModelComparePluginDescriptor> descriptors = new ArrayList<SModelComparePluginDescriptor>();
        for (ModelComparePlugin queryEnginePlugin : this.pluginManager.getAllModelComparePlugins(true).values()) {
            SModelComparePluginDescriptor descriptor = new SModelComparePluginDescriptor();
            descriptor.setDefaultName(queryEnginePlugin.getDefaultName());
            descriptor.setPluginClassName(queryEnginePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<SModelCheckerPluginDescriptor> getAllModelCheckerPluginDescriptors() {
        ArrayList<SModelCheckerPluginDescriptor> descriptors = new ArrayList<SModelCheckerPluginDescriptor>();
        for (ModelCheckerPlugin queryEnginePlugin : this.pluginManager.getAllModelCheckerPlugins(true).values()) {
            SModelCheckerPluginDescriptor descriptor = new SModelCheckerPluginDescriptor();
            descriptor.setDefaultName(queryEnginePlugin.getDefaultName());
            descriptor.setPluginClassName(queryEnginePlugin.getClass().getName());
            descriptors.add(descriptor);
        }
        return descriptors;
    }
}

