/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.common.base.Charsets;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.interfaces.objects.SCompareType;
import org.bimserver.interfaces.objects.SDownloadResult;
import org.bimserver.interfaces.objects.SExtendedData;
import org.bimserver.interfaces.objects.SFile;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.LongActionState;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.notifications.ProgressTopic;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.serializers.ExtendedDataSource;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadServlet.class);

    public DownloadServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String token;
            boolean zip;
            String acceptEncoding = request.getHeader("Accept-Encoding");
            boolean useGzip = false;
            if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                useGzip = true;
            }
            Object outputStream = response.getOutputStream();
            boolean bl = zip = request.getParameter("zip") != null && request.getParameter("zip").equals("on");
            if (useGzip && !zip) {
                response.setHeader("Content-Encoding", "gzip");
                outputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            }
            if ((token = (String)request.getSession().getAttribute("token")) == null) {
                token = request.getParameter("token");
            }
            long topicId = -1L;
            if (request.getParameter("topicId") != null) {
                topicId = Long.parseLong(request.getParameter("topicId"));
            }
            ServiceMap serviceMap = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL);
            String action = request.getParameter("action");
            if (action != null) {
                if (action.equals("extendeddata")) {
                    SExtendedData sExtendedData = serviceMap.getBimsie1ServiceInterface().getExtendedData(Long.valueOf(Long.parseLong(request.getParameter("edid"))));
                    SFile file = serviceMap.getServiceInterface().getFile(Long.valueOf(sExtendedData.getFileId()));
                    if (file.getMime() != null) {
                        response.setContentType(file.getMime());
                    }
                    if (file.getFilename() != null) {
                        response.setHeader("Content-Disposition", "inline; filename=\"" + file.getFilename() + "\"");
                    }
                    ((OutputStream)outputStream).write(file.getData());
                    if (outputStream instanceof GZIPOutputStream) {
                        ((GZIPOutputStream)outputStream).finish();
                    }
                    ((OutputStream)outputStream).flush();
                    return;
                }
                if (action.equals("getfile")) {
                    String type = request.getParameter("type");
                    if (type.equals("proto")) {
                        try {
                            String protocolBuffersFile = serviceMap.getAdminInterface().getProtocolBuffersFile(request.getParameter("name"));
                            ((OutputStream)outputStream).write(protocolBuffersFile.getBytes(Charsets.UTF_8));
                            ((OutputStream)outputStream).flush();
                        }
                        catch (ServiceException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    } else if (type.equals("serverlog")) {
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream);
                            writer.write(serviceMap.getAdminInterface().getServerLog());
                            writer.flush();
                        }
                        catch (ServerException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        catch (UserException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                }
            } else {
                SSerializerPluginConfiguration serializer = null;
                if (request.getParameter("serializerOid") != null) {
                    long serializerOid = Long.parseLong(request.getParameter("serializerOid"));
                    serializer = serviceMap.getBimsie1ServiceInterface().getSerializerById(Long.valueOf(serializerOid));
                } else {
                    serializer = serviceMap.getBimsie1ServiceInterface().getSerializerByName(request.getParameter("serializerName"));
                }
                if (request.getParameter("multiple") != null) {
                    HashSet<Long> roids = new HashSet<Long>();
                    for (Object key : request.getParameterMap().keySet()) {
                        String[] keyString = (String[])key;
                        if (!keyString.startsWith("download_") || request.getParameter((String)keyString).equals("[off]")) continue;
                        roids.add(Long.parseLong(request.getParameter((String)keyString)));
                    }
                    topicId = serviceMap.getBimsie1ServiceInterface().downloadRevisions(roids, Long.valueOf(serializer.getOid()), Boolean.valueOf(true));
                } else if (request.getParameter("compare") != null) {
                    SCompareType sCompareType = SCompareType.valueOf((String)request.getParameter("type"));
                    Long roid1 = Long.parseLong(request.getParameter("roid1"));
                    Long roid2 = Long.parseLong(request.getParameter("roid2"));
                    topicId = serviceMap.getServiceInterface().downloadCompareResults(Long.valueOf(serializer.getOid()), roid1, roid2, Long.valueOf(request.getParameter("mcid")), sCompareType, Boolean.valueOf(true));
                } else if (request.getParameter("topicId") != null) {
                    topicId = Long.parseLong(request.getParameter("topicId"));
                } else {
                    Object roids;
                    long roid = -1L;
                    if (request.getParameter("roid") == null) {
                        if (request.getParameter("poid") == null) throw new UserException("A poid or roid is required for downloading");
                        long poid = Long.parseLong(request.getParameter("poid"));
                        SProject projectByPoid = serviceMap.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(poid));
                        if (projectByPoid == null) {
                            throw new UserException("Project with oid " + poid + " not found");
                        }
                        roid = projectByPoid.getLastRevisionId();
                        if (roid == -1L) {
                            throw new UserException("No revisions");
                        }
                    } else {
                        roid = Long.parseLong(request.getParameter("roid"));
                    }
                    if (request.getParameter("checkout") != null) {
                        topicId = serviceMap.getBimsie1ServiceInterface().checkout(Long.valueOf(roid), Long.valueOf(serializer.getOid()), Boolean.valueOf(true));
                    } else if (request.getParameter("classses") != null) {
                        HashSet<String> classes = new HashSet<String>();
                        for (String className : request.getParameter("classses").split(";")) {
                            classes.add(className);
                        }
                        roids = new HashSet();
                        roids.add(roid);
                        topicId = serviceMap.getBimsie1ServiceInterface().downloadByTypes((Set)roids, "ifc2x3tc1", classes, Long.valueOf(serializer.getOid()), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
                    } else if (request.getParameter("oids") != null) {
                        HashSet<Long> oids = new HashSet<Long>();
                        for (String oidString : request.getParameter("oids").split(";")) {
                            oids.add(Long.parseLong(oidString));
                        }
                        roids = new HashSet();
                        roids.add(roid);
                        topicId = serviceMap.getBimsie1ServiceInterface().downloadByOids((Set)roids, oids, Long.valueOf(serializer.getOid()), Boolean.valueOf(true), Boolean.valueOf(true));
                    } else if (request.getParameter("guids") != null) {
                        HashSet<Object> guids = new HashSet<Object>();
                        for (String guid : request.getParameter("guids").split(";")) {
                            guids.add(guid);
                        }
                        roids = new HashSet();
                        roids.add(roid);
                        topicId = serviceMap.getBimsie1ServiceInterface().downloadByGuids((Set)roids, guids, Long.valueOf(serializer.getOid()), Boolean.valueOf(false), Boolean.valueOf(true));
                    } else {
                        topicId = serviceMap.getBimsie1ServiceInterface().download(Long.valueOf(roid), Long.valueOf(serializer.getOid()), Boolean.valueOf(true), Boolean.valueOf(true));
                    }
                }
                if (topicId == -1L) {
                    response.getWriter().println("No valid topicId");
                    return;
                }
                SDownloadResult checkoutResult = serviceMap.getBimsie1ServiceInterface().getDownloadData(Long.valueOf(topicId));
                if (checkoutResult == null) {
                    LOGGER.error("Invalid topicId: " + topicId);
                } else {
                    DataSource dataSource = checkoutResult.getFile().getDataSource();
                    PluginConfiguration pluginConfiguration = new PluginConfiguration(serviceMap.getPluginInterface().getPluginSettings(Long.valueOf(serializer.getOid())));
                    final ProgressTopic progressTopic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
                    ProgressReporter progressReporter = new ProgressReporter(){
                        private long lastMax;
                        private long lastProgress;
                        private int stage = 3;
                        private Date start = new Date();
                        private String title = "Downloading...";

                        public void update(long progress, long max) {
                            if (progressTopic != null) {
                                LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                                ds.setStart(this.start);
                                ds.setState(progress == max ? ActionState.FINISHED : ActionState.STARTED);
                                ds.setTitle(this.title);
                                ds.setStage(this.stage);
                                ds.setProgress(Integer.valueOf((int)Math.round(100.0 * (double)progress / (double)max)));
                                progressTopic.stageProgressUpdate(ds);
                                this.lastMax = max;
                                this.lastProgress = progress;
                            }
                        }

                        public void setTitle(String title) {
                            if (progressTopic != null) {
                                ++this.stage;
                                this.title = title;
                                LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                                ds.setStart(new Date());
                                ds.setState(this.lastProgress == this.lastMax ? ActionState.FINISHED : ActionState.STARTED);
                                ds.setTitle(title);
                                ds.setStage(this.stage);
                                ds.setProgress(Integer.valueOf((int)Math.round(100.0 * (double)this.lastProgress / (double)this.lastMax)));
                                progressTopic.stageProgressUpdate(ds);
                            }
                        }
                    };
                    try {
                        if (zip) {
                            if (pluginConfiguration.getString("ZipExtension") != null) {
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + "." + pluginConfiguration.getString("ZipExtension") + "\"");
                            } else {
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + ".zip" + "\"");
                            }
                            response.setContentType("application/zip");
                            String nameInZip = dataSource.getName() + "." + pluginConfiguration.getString("Extension");
                            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
                            zipOutputStream.putNextEntry(new ZipEntry(nameInZip));
                            this.processDataSource(zipOutputStream, dataSource, progressReporter);
                            try {
                                zipOutputStream.finish();
                            }
                            catch (IOException iOException) {}
                        } else {
                            if (request.getParameter("mime") == null) {
                                response.setContentType(pluginConfiguration.getString("ContentType"));
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + "." + pluginConfiguration.getString("Extension") + "\"");
                            } else {
                                response.setContentType(request.getParameter("mime"));
                            }
                            this.processDataSource((OutputStream)outputStream, dataSource, progressReporter);
                        }
                    }
                    catch (SerializerException s) {
                        LOGGER.error("", (Throwable)s);
                        LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                        ds.setStart(new Date());
                        ds.setState(ActionState.AS_ERROR);
                        ds.setTitle("Serialization Error");
                        ds.setProgress(Integer.valueOf(-1));
                        ds.setStage(3);
                        ds.getErrors().add((Object)s.getMessage());
                        progressTopic.stageProgressUpdate(ds);
                    }
                }
            }
            if (outputStream instanceof GZIPOutputStream) {
                ((GZIPOutputStream)outputStream).finish();
            }
            ((OutputStream)outputStream).flush();
            return;
        }
        catch (NumberFormatException e) {
            LOGGER.error("", (Throwable)e);
            response.getWriter().println("Some number was incorrectly formatted");
            return;
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
            response.getWriter().println(e.getUserMessage());
            return;
        }
        catch (EOFException e) {
            return;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void processDataSource(OutputStream outputStream, DataSource dataSource, ProgressReporter progressReporter) throws IOException, SerializerException, BimserverDatabaseException {
        if (!(dataSource instanceof ExtendedDataSource)) {
            throw new SerializerException("Unsupported datasource type: " + dataSource);
        }
        ((ExtendedDataSource)dataSource).writeToOutputStream(outputStream, progressReporter);
    }
}

