/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.bimserver.BimServer;
import org.bimserver.servlets.StatusCodeModifyingFaultInterceptor;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.Token;
import org.bimserver.webservices.CustomInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWebServiceServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericWebServiceServlet.class);
    private String bindingId;
    private static final String REDIRECTS_PARAMETER = "redirects-list";
    private static final String REDIRECT_SERVLET_NAME_PARAMETER = "redirect-servlet-name";
    private static final String REDIRECT_SERVLET_PATH_PARAMETER = "redirect-servlet-path";
    private static final String REDIRECT_QUERY_CHECK_PARAMETER = "redirect-query-check";
    private static final Map<String, String> STATIC_CONTENT_TYPES = new HashMap<String, String>();
    private List<String> redirectList;
    private String dispatcherServletPath;
    private String dispatcherServletName;
    private boolean redirectQueryCheck;
    private DestinationRegistry destinationRegistry;
    private Bus bus;
    private ServletController controller;
    private ClassLoader loader;

    public GenericWebServiceServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public void init(ServletConfig sc) throws ServletException {
        System.setProperty("javax.wsdl.factory.WSDLFactory", "com.ibm.wsdl.factory.WSDLFactoryImpl");
        if (this.bus == null) {
            this.loadBus(sc);
        }
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(sc.getServletContext()));
        if (this.destinationRegistry == null) {
            this.destinationRegistry = GenericWebServiceServlet.getDestinationRegistryFromBus(this.bus);
        }
        this.controller = this.createServletController(sc);
        this.redirectList = GenericWebServiceServlet.parseListSequence(sc.getInitParameter(REDIRECTS_PARAMETER));
        this.redirectQueryCheck = Boolean.valueOf(sc.getInitParameter(REDIRECT_QUERY_CHECK_PARAMETER));
        this.dispatcherServletName = sc.getInitParameter(REDIRECT_SERVLET_NAME_PARAMETER);
        this.dispatcherServletPath = sc.getInitParameter(REDIRECT_SERVLET_PATH_PARAMETER);
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException busException) {
            // empty catch block
        }
        return null;
    }

    private ServletController createServletController(ServletConfig servletConfig) {
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        ServletController newController = new ServletController(this.destinationRegistry, servletConfig, (HttpServlet)serviceListGeneratorServlet);
        return newController;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.loader != null) {
                Thread.currentThread().setContextClassLoader(this.loader);
            }
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            this.controller.invoke(request, response);
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (String path : this.destinationRegistry.getDestinationsPaths()) {
            AbstractHTTPDestination dest;
            AbstractHTTPDestination abstractHTTPDestination = dest = this.destinationRegistry.getDestinationForPath(path);
            synchronized (abstractHTTPDestination) {
                this.destinationRegistry.removeDestination(path);
                dest.releaseRegistry();
            }
        }
        this.destinationRegistry = null;
        this.destroyBus();
    }

    public void destroyBus() {
        this.bus.shutdown(true);
    }

    private static List<String> parseListSequence(String values) {
        if (values != null) {
            String[] pathValues;
            LinkedList<String> list = new LinkedList<String>();
            for (String value : pathValues = values.split(" ")) {
                String theValue = value.trim();
                if (theValue.length() <= 0) continue;
                list.add(theValue);
            }
            return list;
        }
        return null;
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if ((this.dispatcherServletPath != null || this.dispatcherServletName != null) && (this.redirectList != null && this.matchPath(this.redirectList, request) || this.redirectList == null)) {
            this.redirect(request, response, request.getPathInfo());
            return;
        }
        this.invoke(request, response);
    }

    private boolean matchPath(List<String> values, HttpServletRequest request) {
        String queryString;
        String path = request.getPathInfo();
        if (this.redirectQueryCheck && (queryString = request.getQueryString()) != null && queryString.length() > 0) {
            path = path + "?" + queryString;
        }
        for (String value : values) {
            if (!path.matches(value)) continue;
            return true;
        }
        return false;
    }

    protected void serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        InputStream is = super.getServletContext().getResourceAsStream(pathInfo);
        if (is == null) {
            throw new ServletException("Static resource " + pathInfo + " is not available");
        }
        try {
            String type;
            int ind = pathInfo.lastIndexOf(".");
            if (ind != -1 && ind < pathInfo.length() && (type = STATIC_CONTENT_TYPES.get(pathInfo.substring(ind + 1))) != null) {
                response.setContentType(type);
            }
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
        }
        catch (IOException ex) {
            throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
        }
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        RequestDispatcher rd;
        String theServletPath = this.dispatcherServletPath == null ? "/" : this.dispatcherServletPath;
        ServletContext sc = super.getServletContext();
        RequestDispatcher requestDispatcher = rd = this.dispatcherServletName != null ? sc.getNamedDispatcher(this.dispatcherServletName) : sc.getRequestDispatcher(theServletPath + pathInfo);
        if (rd == null) {
            throw new ServletException("No RequestDispatcher can be created for path " + pathInfo);
        }
        try {
            HttpServletRequestFilter servletRequest = new HttpServletRequestFilter(request, pathInfo, theServletPath);
            rd.forward((ServletRequest)servletRequest, (ServletResponse)response);
        }
        catch (Throwable ex) {
            throw new ServletException("RequestDispatcher for path " + pathInfo + " has failed");
        }
    }

    public void loadBus(ServletConfig servletConfig) {
        this.bus = BusFactory.newInstance().createBus();
        Bus bus = this.getBus();
        HeaderManager headerManager = (HeaderManager)bus.getExtension(HeaderManager.class);
        headerManager.registerHeaderProcessor(new HeaderProcessor(){

            public String getNamespace() {
                return "uri:org.bimserver.shared";
            }

            public InterceptorProvider getInterceptorProvider() {
                return null;
            }

            public DataBinding getDataBinding() {
                try {
                    return new JAXBDataBinding(new Class[]{Token.class});
                }
                catch (JAXBException e) {
                    LOGGER.error("", (Throwable)e);
                    return null;
                }
            }
        });
        BusFactory.setDefaultBus((Bus)bus);
        for (Class clazz : this.getBimServer().getServicesMap().getInterfaceClasses()) {
            JaxWsServerFactoryBean serverFactoryBean = new JaxWsServerFactoryBean();
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("mtom-enabled", Boolean.TRUE);
            serverFactoryBean.setBindingId(this.bindingId);
            serverFactoryBean.setProperties(properties);
            serverFactoryBean.setServiceClass(clazz);
            serverFactoryBean.getOutFaultInterceptors().add(new StatusCodeModifyingFaultInterceptor());
            serverFactoryBean.setInvoker((Invoker)new CustomInvoker(this.getBimServer().getServiceFactory(), clazz));
            serverFactoryBean.setAddress((this.bindingId == "http://schemas.xmlsoap.org/wsdl/soap/" ? "/soap11/" : "/soap12/") + clazz.getSimpleName());
            serverFactoryBean.setTransportId("http://schemas.xmlsoap.org/soap/http");
            serverFactoryBean.create();
        }
    }

    static {
        STATIC_CONTENT_TYPES.put("html", "text/html");
        STATIC_CONTENT_TYPES.put("txt", "text/plain");
        STATIC_CONTENT_TYPES.put("css", "text/css");
        STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
    }

    private static class HttpServletRequestFilter
    extends HttpServletRequestWrapper {
        private String pathInfo;
        private String servletPath;

        public HttpServletRequestFilter(HttpServletRequest request, String pathInfo, String servletPath) {
            super(request);
            this.pathInfo = pathInfo;
            this.servletPath = servletPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            String contextPath = this.getContextPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            return contextPath + this.servletPath + this.pathInfo;
        }

        public String getParameter(String name) {
            if ("http.service.redirection".equals(name)) {
                return "true";
            }
            return super.getParameter(name);
        }
    }
}

