/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.models.store.ServerState;
import org.bimserver.servlets.SubServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiServlet.class);

    public JsonApiServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getHeader("Origin") != null && this.getBimServer().getServerInfo().getServerState() != ServerState.MIGRATION_REQUIRED && !this.getBimServer().getServerSettingsCache().isHostAllowed(request.getHeader("Origin"))) {
            response.setStatus(403);
            return;
        }
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Headers", "Content-Type");
        response.setCharacterEncoding("UTF-8");
        try {
            JsonReader jsonReader;
            JsonParser parser;
            JsonElement parse;
            ServletInputStream inputStream = request.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Incoming JSON " + new String(bytes, Charsets.UTF_8));
            }
            if ((parse = (parser = new JsonParser()).parse(jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8)))) instanceof JsonObject) {
                JsonObject jsonRequest = (JsonObject)parse;
                response.setHeader("Content-Type", "application/json");
                this.getBimServer().getJsonHandler().execute(jsonRequest, request, response.getWriter());
            } else {
                LOGGER.error("Invalid JSON request: " + new String(bytes, Charsets.UTF_8));
                response.setStatus(500);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            response.setStatus(500);
        }
    }
}

