/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.servlets.DownloadServlet;
import org.bimserver.servlets.JsonApiServlet;
import org.bimserver.servlets.SyndicationServlet;
import org.bimserver.servlets.UploadServlet;
import org.bimserver.servlets.WebServiceServlet11;
import org.bimserver.servlets.WebServiceServlet12;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootServlet
extends HttpServlet {
    private static final long serialVersionUID = -6631574771887074019L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RootServlet.class);
    private WebServiceServlet11 soap11Servlet;
    private WebServiceServlet12 soap12Servlet;
    private SyndicationServlet syndicationServlet;
    private JsonApiServlet jsonApiServlet;
    private UploadServlet uploadServlet;
    private DownloadServlet downloadServlet;
    private BimServer bimServer;

    public void init() throws ServletException {
        super.init();
        this.bimServer = (BimServer)this.getServletContext().getAttribute("bimserver");
        this.jsonApiServlet = new JsonApiServlet(this.bimServer, this.getServletContext());
        this.syndicationServlet = new SyndicationServlet(this.bimServer, this.getServletContext());
        this.uploadServlet = new UploadServlet(this.bimServer, this.getServletContext());
        this.downloadServlet = new DownloadServlet(this.bimServer, this.getServletContext());
        this.soap11Servlet = new WebServiceServlet11(this.bimServer, this.getServletContext());
        this.soap11Servlet.init(this.getServletConfig());
        this.soap12Servlet = new WebServiceServlet12(this.bimServer, this.getServletContext());
        this.soap12Servlet.init(this.getServletConfig());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block37: {
            try {
                String servletContextPath;
                String requestOrigin = request.getHeader("Origin");
                if (requestOrigin != null && !this.bimServer.getServerSettingsCache().isHostAllowed(requestOrigin)) {
                    response.setStatus(403);
                    return;
                }
                if (requestOrigin != null) {
                    response.setHeader("Access-Control-Allow-Origin", requestOrigin);
                } else {
                    response.setHeader("Access-Control-Allow-Origin", "*");
                }
                response.setHeader("Access-Control-Allow-Headers", "Content-Type");
                if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
                    return;
                }
                String requestUri = request.getRequestURI();
                if (requestUri.startsWith(servletContextPath = this.getServletContext().getContextPath())) {
                    requestUri = requestUri.substring(servletContextPath.length());
                }
                if (requestUri == null) {
                    LOGGER.error("RequestURI is null");
                } else {
                    LOGGER.debug(requestUri);
                }
                this.setContentType(response, requestUri);
                if (request.getRequestURI().endsWith(".getbimserveraddress")) {
                    response.setContentType("application/json; charset=utf-8");
                    String siteAddress = this.bimServer.getServerSettingsCache().getServerSettings().getSiteAddress();
                    if (siteAddress == null || siteAddress.trim().isEmpty()) {
                        siteAddress = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                    }
                    if (siteAddress.contains("http://")) {
                        siteAddress = siteAddress.replace("http://", request.getScheme() + "://");
                    }
                    response.getWriter().print("{\"address\":\"" + siteAddress + "\"}");
                    return;
                }
                if (requestUri.startsWith("/stream")) {
                    LOGGER.warn("Stream request should not be going to this servlet!");
                } else if (requestUri.startsWith("/soap11/") || requestUri.equals("/soap11")) {
                    this.soap11Servlet.service(request, response);
                } else if (requestUri.startsWith("/soap12/") || requestUri.equals("/soap12")) {
                    this.soap12Servlet.service(request, response);
                } else if (requestUri.startsWith("/syndication/") || requestUri.equals("/syndication")) {
                    this.syndicationServlet.service(request, response);
                } else if (requestUri.startsWith("/json/") || requestUri.equals("/json")) {
                    this.jsonApiServlet.service(request, response);
                } else if (requestUri.startsWith("/upload/") || requestUri.equals("/upload")) {
                    this.uploadServlet.service(request, response);
                } else if (requestUri.startsWith("/download/") || requestUri.equals("/download")) {
                    this.downloadServlet.service(request, response);
                } else {
                    String modulePath;
                    if (requestUri.equals("") || requestUri.equals("/") || requestUri == null) {
                        requestUri = "/index.html";
                    }
                    if (this.bimServer.getDefaultWebModule() == null) {
                        LOGGER.info("No default web module");
                    }
                    if ((modulePath = requestUri).indexOf("/", 1) != -1) {
                        modulePath = modulePath.substring(0, modulePath.indexOf("/", 1));
                    }
                    int originalLength = modulePath.length();
                    if (modulePath.startsWith("/")) {
                        modulePath = modulePath.substring(1);
                    }
                    if (this.bimServer.getWebModules().containsKey(modulePath)) {
                        String substring = requestUri.substring(originalLength);
                        if (this.bimServer.getWebModules().get(modulePath).service(substring, response)) {
                            return;
                        }
                    }
                    if (this.bimServer.getDefaultWebModule() != null && this.bimServer.getDefaultWebModule().service(requestUri, response)) {
                        return;
                    }
                    InputStream resourceAsStream = this.getServletContext().getResourceAsStream(requestUri);
                    if (resourceAsStream != null) {
                        IOUtils.copy((InputStream)resourceAsStream, (OutputStream)response.getOutputStream());
                    } else {
                        response.setStatus(404);
                        try {
                            response.getWriter().println("404 - Not Found");
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException) break block37;
                LOGGER.error("", e);
            }
        }
    }

    private void setContentType(HttpServletResponse response, String requestUri) {
        if (requestUri.endsWith(".js")) {
            response.setContentType("application/javascript; charset=utf-8");
        } else if (requestUri.endsWith(".css")) {
            response.setContentType("text/css; charset=utf-8");
        } else if (requestUri.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (requestUri.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else {
            response.setContentType("text/html; charset=utf-8");
        }
    }
}

