/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.GregorianCalendar;
import org.apache.commons.io.output.NullWriter;
import org.bimserver.BimServer;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongDownloadOrCheckoutAction;
import org.bimserver.longaction.LongStreamingDownloadAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.servlets.JsonWebsocketReflector;
import org.bimserver.shared.StreamingSocketInterface;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1NotificationInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.utils.Formatters;
import org.bimserver.webservices.ServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Streamer
implements EndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(Streamer.class);
    private long uoid;
    private long endpointid;
    private BimServer bimServer;
    private Bimsie1NotificationInterface notificationInterface;
    private Bimsie1RemoteServiceInterface remoteServiceInterface;
    private StreamingSocketInterface streamingSocketInterface;
    private static final int BUFFER_SIZE = -1;

    public Streamer(StreamingSocketInterface streamingSocketInterface, BimServer bimServer) {
        this.streamingSocketInterface = streamingSocketInterface;
        this.bimServer = bimServer;
        this.notificationInterface = (Bimsie1NotificationInterface)bimServer.getReflectorFactory().createReflector(Bimsie1NotificationInterface.class, (Reflector)new JsonWebsocketReflector(bimServer.getServicesMap(), streamingSocketInterface));
        this.remoteServiceInterface = (Bimsie1RemoteServiceInterface)bimServer.getReflectorFactory().createReflector(Bimsie1RemoteServiceInterface.class, (Reflector)new JsonWebsocketReflector(bimServer.getServicesMap(), streamingSocketInterface));
    }

    public void onOpen() {
        JsonObject welcome = new JsonObject();
        welcome.add("welcome", (JsonElement)new JsonPrimitive((Number)new GregorianCalendar().getTimeInMillis()));
        this.streamingSocketInterface.send(welcome);
    }

    public void onText(Reader reader) {
        JsonParser parser = new JsonParser();
        JsonReader jsonreader = new JsonReader(reader);
        JsonObject request = (JsonObject)parser.parse(jsonreader);
        if (!request.has("hb")) {
            if (request.has("action")) {
                if (request.get("action").getAsString().equals("download")) {
                    final int topicId = request.get("topicId").getAsInt();
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                LongAction<?> longAction = Streamer.this.bimServer.getLongActionManager().getLongAction(topicId);
                                org.bimserver.plugins.serializers.Writer writer = null;
                                if (longAction instanceof LongStreamingDownloadAction) {
                                    LongStreamingDownloadAction longStreamingDownloadAction = (LongStreamingDownloadAction)longAction;
                                    writer = longStreamingDownloadAction.getMessagingStreamingSerializer();
                                } else {
                                    LongDownloadOrCheckoutAction longDownloadAction = (LongDownloadOrCheckoutAction)longAction;
                                    writer = longDownloadAction.getMessagingSerializer();
                                }
                                boolean writeMessage = true;
                                int counter = 0;
                                long bytes = 0L;
                                long start = System.nanoTime();
                                do {
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                    dataOutputStream.writeInt(topicId);
                                    dataOutputStream.writeInt(0);
                                    writeMessage = writer.writeMessage((OutputStream)byteArrayOutputStream, null);
                                    int messages = 1;
                                    while (byteArrayOutputStream.size() < -1 && writeMessage) {
                                        ++messages;
                                        writeMessage = writer.writeMessage((OutputStream)byteArrayOutputStream, null);
                                    }
                                    byte[] byteArray = byteArrayOutputStream.toByteArray();
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
                                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                                    byteBuffer.putInt(4, messages);
                                    if (byteArrayOutputStream.size() <= 8) continue;
                                    bytes += (long)byteArray.length;
                                    Streamer.this.streamingSocketInterface.send(byteArray, 0, byteArray.length);
                                    ++counter;
                                } while (writeMessage);
                                long end = System.nanoTime();
                                LOGGER.info(counter + " messages written " + Formatters.bytesToString((long)bytes) + " in " + (end - start) / 1000000L + " ms");
                            }
                            catch (IOException | SerializerException e) {
                                LOGGER.error("", e);
                            }
                        }
                    };
                    thread.setName("Streamer " + topicId);
                    thread.start();
                }
            } else if (request.has("token")) {
                String token = request.get("token").getAsString();
                try {
                    ServiceMap serviceMap = this.bimServer.getServiceFactory().get(token, AccessMethod.JSON);
                    this.uoid = serviceMap.getBimServerAuthInterface().getLoggedInUser().getOid();
                    this.endpointid = this.bimServer.getEndPointManager().register(this);
                    JsonObject enpointMessage = new JsonObject();
                    enpointMessage.add("endpointid", (JsonElement)new JsonPrimitive((Number)this.endpointid));
                    this.streamingSocketInterface.send(enpointMessage);
                }
                catch (UserException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (ServerException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                this.bimServer.getJsonHandler().execute(request, null, (Writer)new NullWriter());
            }
        }
    }

    @Override
    public void cleanup() {
        this.bimServer.getEndPointManager().unregister(this.endpointid);
    }

    public void onClose() {
        LOGGER.info("onClose, unregistering endpoint " + this.getEndPointId());
        this.bimServer.getEndPointManager().unregister(this);
    }

    @Override
    public long getEndPointId() {
        return this.endpointid;
    }

    @Override
    public Bimsie1NotificationInterface getNotificationInterface() {
        return this.notificationInterface;
    }

    @Override
    public Bimsie1RemoteServiceInterface getRemoteServiceInterface() {
        return this.remoteServiceInterface;
    }

    @Override
    public long getUoid() {
        return this.uoid;
    }

    public String toString() {
        return "" + this.endpointid;
    }
}

