/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import org.bimserver.servlets.Streamer;
import org.bimserver.shared.StreamingSocketInterface;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketException;

public class StreamingSocket
extends WebSocketAdapter
implements StreamingSocketInterface {
    private Session session;
    private Streamer streamer;

    public void setStreamer(Streamer streamer) {
        this.streamer = streamer;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketClose(int arg0, String arg1) {
        this.streamer.onClose();
    }

    public void onWebSocketText(String message) {
        this.streamer.onText(new StringReader(message));
    }

    public void onWebSocketConnect(Session session) {
        session.setIdleTimeout(3600000L);
        this.session = session;
        this.streamer.onOpen();
    }

    public void send(JsonObject object) {
        try {
            this.session.getRemote().sendStringByFuture(object.toString());
        }
        catch (WebSocketException webSocketException) {
            // empty catch block
        }
    }

    public void send(byte[] data, int start, int length) {
        this.session.getRemote().sendBytesByFuture(ByteBuffer.wrap(data, start, length));
    }

    public synchronized void sendBlocking(byte[] data, int start, int length) {
        try {
            this.session.getRemote().sendBytes(ByteBuffer.wrap(data, start, length));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

