/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.common.base.Charsets;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.bimserver.BimServer;
import org.bimserver.interfaces.objects.SCheckout;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.comparators.SRevisionIdComparator;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyndicationServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyndicationServlet.class);
    private static final String FEED_TYPE = "atom_1.0";

    public SyndicationServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            if (request.getHeader("Origin") != null && !this.getBimServer().getServerSettingsCache().isHostAllowed(request.getHeader("Origin"))) {
                response.setStatus(403);
                return;
            }
            if (request.getHeader("Authorization") != null) {
                String authorization = request.getHeader("Authorization");
                String usernamePasswordEncoded = authorization.substring(6);
                String decodeBase64 = new String(Base64.decodeBase64((byte[])usernamePasswordEncoded.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
                if (decodeBase64.equals(":")) {
                    response.getWriter().print("Not authenticated");
                    return;
                }
                String[] split = decodeBase64.split(":");
                String username = split[0];
                String password = split[1];
                String token = (String)this.getServletContext().getAttribute("token");
                ServiceMap serviceMap = null;
                try {
                    serviceMap = token == null ? this.getBimServer().getServiceFactory().get(AccessMethod.SYNDICATION) : this.getBimServer().getServiceFactory().get(token, AccessMethod.SYNDICATION);
                    if (serviceMap.getBimsie1AuthInterface().login(username, password) != null) {
                        String requestURI = request.getRequestURI();
                        response.setContentType("application/atom+xml");
                        try {
                            if (requestURI.endsWith("/projects")) {
                                this.writeProjectsFeed(request, response, serviceMap);
                            } else if (requestURI.contains("/revisions")) {
                                this.writeRevisionsFeed(request, response, serviceMap);
                            } else if (requestURI.contains("/checkouts")) {
                                this.writeCheckoutsFeed(request, response, serviceMap);
                            }
                            break block16;
                        }
                        catch (ServiceException e) {
                            response.setContentType("text/html");
                            response.getWriter().println(e.getUserMessage());
                        }
                        catch (FeedException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        break block16;
                    }
                    response.setStatus(401);
                    response.setHeader("WWW-Authenticate", "Basic realm=\"Secure Area\"");
                }
                catch (ServiceException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (PublicInterfaceNotFoundException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "Basic realm=\"Secure Area\"");
            }
        }
    }

    private void writeProjectsFeed(HttpServletRequest request, HttpServletResponse response, ServiceMap serviceMap) throws UserException, IOException, FeedException, PublicInterfaceNotFoundException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(FEED_TYPE);
        feed.setTitle("BIMserver.org projects feed");
        feed.setLink(request.getContextPath());
        feed.setDescription("This feed represents all your available projects within this BIMserver");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            List allProjects = serviceMap.getBimsie1ServiceInterface().getAllProjects(Boolean.valueOf(false), Boolean.valueOf(true));
            for (SProject sProject : allProjects) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setAuthor(serviceMap.getServiceInterface().getUserByUoid(Long.valueOf(sProject.getCreatedById())).getName());
                entry.setTitle(sProject.getName());
                entry.setLink(request.getContextPath() + "/project.jsp?poid=" + sProject.getOid());
                entry.setPublishedDate(sProject.getCreatedDate());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(sProject.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
            if (allProjects.size() == 0) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle("No projects found");
                entry.setLink(request.getContextPath() + "/main.jsp");
                entry.setPublishedDate(new Date());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue("No projects found");
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        feed.setEntries(entries);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output((SyndFeed)feed, (Writer)response.getWriter());
    }

    private void writeRevisionsFeed(HttpServletRequest request, HttpServletResponse response, ServiceMap serviceMap) throws IOException, FeedException, ServiceException, PublicInterfaceNotFoundException {
        long poid = Long.parseLong(request.getParameter("poid"));
        SProject sProject = serviceMap.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(poid));
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(FEED_TYPE);
        feed.setTitle("BIMserver.org revisions feed for project '" + sProject.getName() + "'");
        feed.setLink(request.getContextPath());
        feed.setDescription("This feed represents all the revisions of project '" + sProject.getName() + "'");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            List allRevisionsOfProject = serviceMap.getBimsie1ServiceInterface().getAllRevisionsOfProject(Long.valueOf(poid));
            Collections.sort(allRevisionsOfProject, new SRevisionIdComparator(false));
            for (SRevision sVirtualRevision : allRevisionsOfProject) {
                SUser user = serviceMap.getServiceInterface().getUserByUoid(Long.valueOf(sVirtualRevision.getUserId()));
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle("Revision " + sVirtualRevision.getOid());
                entry.setLink(request.getContextPath() + "/revision.jsp?poid=" + sVirtualRevision.getOid() + "&roid=" + sVirtualRevision.getOid());
                entry.setPublishedDate(sVirtualRevision.getDate());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/html");
                description.setValue("<table><tr><td>User</td><td>" + user.getUsername() + "</td></tr><tr><td>Comment</td><td>" + sVirtualRevision.getComment() + "</td></tr></table>");
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        feed.setEntries(entries);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output((SyndFeed)feed, (Writer)response.getWriter());
    }

    private void writeCheckoutsFeed(HttpServletRequest request, HttpServletResponse response, ServiceMap serviceMap) throws ServiceException, IOException, FeedException, PublicInterfaceNotFoundException {
        long poid = Long.parseLong(request.getParameter("poid"));
        SProject sProject = serviceMap.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(poid));
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(FEED_TYPE);
        feed.setTitle("BIMserver.org checkouts feed for project '" + sProject.getName() + "'");
        feed.setLink(request.getContextPath());
        feed.setDescription("This feed represents all the checkouts of project '" + sProject.getName() + "'");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            List allCheckoutsOfProject = serviceMap.getServiceInterface().getAllCheckoutsOfProjectAndSubProjects(Long.valueOf(poid));
            for (SCheckout sCheckout : allCheckoutsOfProject) {
                SRevision revision = serviceMap.getBimsie1ServiceInterface().getRevision(Long.valueOf(sCheckout.getRevision().getOid()));
                SProject project = serviceMap.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(sCheckout.getProjectId()));
                SUser user = serviceMap.getServiceInterface().getUserByUoid(Long.valueOf(sCheckout.getUserId()));
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle("Checkout on " + project.getName() + ", revision " + revision.getId());
                entry.setLink(request.getContextPath() + "/project.jsp?poid=" + sProject.getOid());
                entry.setPublishedDate(sCheckout.getDate());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue("<table><tr><td>User</td><td>" + user.getUsername() + "</td></tr><tr><td>Revision</td><td>" + sCheckout.getRevision().getOid() + "</td></tr></table>");
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        feed.setEntries(entries);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output((SyndFeed)feed, (Writer)response.getWriter());
    }
}

