/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.interfaces.objects.SFile;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.utils.InputStreamDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadServlet.class);

    public UploadServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getHeader("Origin") != null && !this.getBimServer().getServerSettingsCache().isHostAllowed(request.getHeader("Origin"))) {
            response.setStatus(403);
            return;
        }
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Headers", "Content-Type");
        String token = (String)request.getSession().getAttribute("token");
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode result = objectMapper.createObjectNode();
        response.setContentType("text/json");
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            long poid = -1L;
            String comment = null;
            if (isMultipart) {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                InputStream in = null;
                String name = "";
                long deserializerOid = -1L;
                boolean merge = false;
                boolean sync = false;
                String compression = null;
                String action = null;
                long topicId = -1L;
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) {
                        if ("action".equals(item.getFieldName())) {
                            action = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if ("token".equals(item.getFieldName())) {
                            token = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if ("poid".equals(item.getFieldName())) {
                            poid = Long.parseLong(Streams.asString((InputStream)item.openStream()));
                            continue;
                        }
                        if ("comment".equals(item.getFieldName())) {
                            comment = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if ("topicId".equals(item.getFieldName())) {
                            topicId = Long.parseLong(Streams.asString((InputStream)item.openStream()));
                            continue;
                        }
                        if ("sync".equals(item.getFieldName())) {
                            sync = Streams.asString((InputStream)item.openStream()).equals("true");
                            continue;
                        }
                        if ("merge".equals(item.getFieldName())) {
                            merge = Streams.asString((InputStream)item.openStream()).equals("true");
                            continue;
                        }
                        if ("compression".equals(item.getFieldName())) {
                            compression = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if (!"deserializerOid".equals(item.getFieldName())) continue;
                        deserializerOid = Long.parseLong(Streams.asString((InputStream)item.openStream()));
                        continue;
                    }
                    name = item.getName();
                    in = item.openStream();
                    if ("file".equals(action)) {
                        ServiceInterface serviceInterface = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL).get(ServiceInterface.class);
                        SFile file = new SFile();
                        file.setData(IOUtils.toByteArray((InputStream)in));
                        file.setFilename(name);
                        result.put("fileId", serviceInterface.uploadFile(file));
                        continue;
                    }
                    if (poid != -1L) {
                        long checkinId;
                        ServiceInterface service;
                        InputStream realStream = null;
                        realStream = "gzip".equals(compression) ? new GZIPInputStream(in) : ("deflate".equals(compression) ? new InflaterInputStream(in) : in);
                        InputStreamDataSource inputStreamDataSource = new InputStreamDataSource(realStream);
                        inputStreamDataSource.setName(name);
                        DataHandler ifcFile = new DataHandler((DataSource)inputStreamDataSource);
                        if (token == null) continue;
                        if (topicId == -1L) {
                            service = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL).get(ServiceInterface.class);
                            checkinId = service.checkin(Long.valueOf(poid), comment, Long.valueOf(deserializerOid), Long.valueOf(-1L), name, ifcFile, Boolean.valueOf(merge), Boolean.valueOf(sync));
                            result.put("checkinid", checkinId);
                            continue;
                        }
                        service = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL).get(ServiceInterface.class);
                        checkinId = service.checkinInitiated(Long.valueOf(topicId), Long.valueOf(poid), comment, Long.valueOf(deserializerOid), Long.valueOf(-1L), name, ifcFile, Boolean.valueOf(merge), Boolean.valueOf(true));
                        result.put("checkinid", checkinId);
                        continue;
                    }
                    result.put("exception", "No poid");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            this.sendException(response, e);
            return;
        }
        response.getWriter().write(result.toString());
    }

    private void sendException(HttpServletResponse response, Exception exception) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode responseObject = objectMapper.createObjectNode();
            ObjectNode exceptionJson = objectMapper.createObjectNode();
            exceptionJson.put("__type", exception.getClass().getSimpleName());
            if (exception.getMessage() == null) {
                exceptionJson.put("message", "Unknown exception");
            } else {
                exceptionJson.put("message", exception.getMessage());
            }
            responseObject.set("exception", (JsonNode)exceptionJson);
            response.getWriter().write(responseObject.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

