/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import java.io.File;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.utils.Licenser;
import org.bimserver.utils.StringUtils;

public class AsyncServiceGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package org.bimserver.shared.interfaces.async;" + this.NL;
    protected final String TEXT_2 = this.NL;
    protected final String TEXT_3 = this.NL + "import java.util.concurrent.ExecutorService;";
    protected final String TEXT_4 = this.NL + "import ";
    protected final String TEXT_5 = ";" + this.NL + "" + this.NL + "public class Async";
    protected final String TEXT_6 = " {" + this.NL + "" + this.NL + "\tprivate final ExecutorService executorService;" + this.NL + "\tprivate final ";
    protected final String TEXT_7 = " syncService;" + this.NL + "" + this.NL + "\tpublic Async";
    protected final String TEXT_8 = "(";
    protected final String TEXT_9 = " syncService, ExecutorService executorService) {" + this.NL + "\t\tthis.executorService = executorService;" + this.NL + "\t\tthis.syncService = syncService;" + this.NL + "\t}" + this.NL;
    protected final String TEXT_10 = this.NL + "\tpublic interface ";
    protected final String TEXT_11 = "Callback {" + this.NL + "\t\tvoid success(";
    protected final String TEXT_12 = ");" + this.NL + "\t\tvoid error(Throwable e);" + this.NL + "\t}" + this.NL + "\t";
    protected final String TEXT_13 = this.NL + this.NL;
    protected final String TEXT_14 = this.NL + "\tpublic void ";
    protected final String TEXT_15 = "(";
    protected final String TEXT_16 = "final ";
    protected final String TEXT_17 = " ";
    protected final String TEXT_18 = ", ";
    protected final String TEXT_19 = "final ";
    protected final String TEXT_20 = "Callback callback) {" + this.NL + "\t\texecutorService.submit(new Runnable(){" + this.NL + "\t\t\tpublic void run(){" + this.NL + "\t\t\t\ttry {";
    protected final String TEXT_21 = this.NL + "\t\t\t\t\tsyncService.";
    protected final String TEXT_22 = "(";
    protected final String TEXT_23 = ");" + this.NL + "\t\t\t\t\tcallback.success();" + this.NL + "\t\t\t\t";
    protected final String TEXT_24 = this.NL + "\t\t\t\t\tcallback.success(syncService.";
    protected final String TEXT_25 = "(";
    protected final String TEXT_26 = "));" + this.NL + "\t\t\t\t";
    protected final String TEXT_27 = "} catch (Throwable e) {" + this.NL + "\t\t\t\t\tcallback.error(e);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t});" + this.NL + "\t}" + this.NL + "\t";
    protected final String TEXT_28 = this.NL + "}";

    public static synchronized AsyncServiceGenerator create(String lineSeparator) {
        nl = lineSeparator;
        AsyncServiceGenerator result = new AsyncServiceGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(Licenser.getCommentedLicenseText((File)new File("license.txt")));
        stringBuffer.append(this.TEXT_3);
        SService sService = (SService)argument;
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(sService.getInterfaceClass().getName());
        stringBuffer.append(this.TEXT_5);
        stringBuffer.append(sService.getInterfaceClass().getSimpleName());
        stringBuffer.append(this.TEXT_6);
        stringBuffer.append(sService.getInterfaceClass().getSimpleName());
        stringBuffer.append(this.TEXT_7);
        stringBuffer.append(sService.getInterfaceClass().getSimpleName());
        stringBuffer.append("(");
        stringBuffer.append(sService.getInterfaceClass().getSimpleName());
        stringBuffer.append(this.TEXT_9);
        for (SMethod method : sService.getMethods()) {
            stringBuffer.append(this.TEXT_10);
            stringBuffer.append(StringUtils.firstUpperCase((String)method.getName()));
            stringBuffer.append(this.TEXT_11);
            stringBuffer.append(method.getReturnType().isVoid() ? "" : method.returnTypeToJavaCode() + " result");
            stringBuffer.append(this.TEXT_12);
        }
        stringBuffer.append(this.TEXT_13);
        for (SMethod method : sService.getMethods()) {
            stringBuffer.append(this.TEXT_14);
            stringBuffer.append(method.getName());
            stringBuffer.append("(");
            for (SParameter parameter : method.getParameters()) {
                stringBuffer.append("final ");
                stringBuffer.append(parameter.getGenericType() != null ? parameter.getType().toJavaCode() + "<" + parameter.getGenericType() + ">" : parameter.getType().toJavaCode());
                stringBuffer.append(" ");
                stringBuffer.append(parameter.getName());
                stringBuffer.append(", ");
            }
            stringBuffer.append("final ");
            stringBuffer.append(StringUtils.firstUpperCase((String)method.getName()));
            stringBuffer.append(this.TEXT_20);
            if (method.getReturnType().isVoid()) {
                stringBuffer.append(this.TEXT_21);
                stringBuffer.append(method.getName());
                stringBuffer.append("(");
                for (SParameter sParameter : method.getParameters()) {
                    stringBuffer.append(sParameter.getName());
                    stringBuffer.append(sParameter.isLast() ? "" : ", ");
                }
                stringBuffer.append(this.TEXT_23);
            } else {
                stringBuffer.append(this.TEXT_24);
                stringBuffer.append(method.getName());
                stringBuffer.append("(");
                for (SParameter sParameter : method.getParameters()) {
                    stringBuffer.append(sParameter.getName());
                    stringBuffer.append(sParameter.isLast() ? "" : ", ");
                }
                stringBuffer.append(this.TEXT_26);
            }
            stringBuffer.append(this.TEXT_27);
        }
        stringBuffer.append(this.TEXT_28);
        return stringBuffer.toString();
    }
}

