/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import javax.activation.DataHandler;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class GenerateUtils {
    public static String makeGetter(EStructuralFeature eStructuralFeature) {
        StringBuilder sb = new StringBuilder();
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
            sb.append("is");
        } else {
            sb.append("get");
        }
        sb.append(GenerateUtils.firstLetterUpperCase(eStructuralFeature.getName()));
        if (eStructuralFeature instanceof EReference && !eStructuralFeature.isMany() && eStructuralFeature.getEAnnotation("embedsreference") == null) {
            sb.append("Id");
        }
        return sb.toString();
    }

    public static String makeSetter(EStructuralFeature eStructuralFeature) {
        StringBuilder sb = new StringBuilder();
        sb.append("set" + GenerateUtils.firstLetterUpperCase(eStructuralFeature.getName()));
        if (eStructuralFeature instanceof EReference && !eStructuralFeature.isMany() && eStructuralFeature.getEAnnotation("embedsreference") == null) {
            sb.append("Id");
        }
        return sb.toString();
    }

    public static String getType(EStructuralFeature eStructuralFeature) {
        boolean embedsReference = eStructuralFeature.getEAnnotation("embedsreference") != null;
        EClassifier eType = eStructuralFeature.getEType();
        if (eStructuralFeature.isMany()) {
            if (eType instanceof EDataType) {
                if (eType == EcorePackage.eINSTANCE.getEString()) {
                    return "List<String>";
                }
                if (eType == EcorePackage.eINSTANCE.getEInt() || eType == EcorePackage.eINSTANCE.getEIntegerObject()) {
                    return "List<Integer>";
                }
                if (eType == EcorePackage.eINSTANCE.getELong() || eType == EcorePackage.eINSTANCE.getELongObject()) {
                    return "List<Long>";
                }
                if (eType == EcorePackage.eINSTANCE.getEDouble() || eType == EcorePackage.eINSTANCE.getEDoubleObject()) {
                    return "List<Double>";
                }
                if (eType == EcorePackage.eINSTANCE.getEBoolean() || eType == EcorePackage.eINSTANCE.getEBooleanObject()) {
                    return "List<Boolean>";
                }
                if (eType == EcorePackage.eINSTANCE.getEFloat() || eType == EcorePackage.eINSTANCE.getEFloatObject()) {
                    return "List<Float>";
                }
                if (eType == EcorePackage.eINSTANCE.getEDate()) {
                    return "List<Date>";
                }
            } else if (eType instanceof EClass) {
                if (embedsReference) {
                    return "List<S" + eType.getName() + ">";
                }
                return "List<Long>";
            }
        } else if (eType instanceof EDataType) {
            if (eType == EcorePackage.eINSTANCE.getEString()) {
                return "String";
            }
            if (eType == EcorePackage.eINSTANCE.getEInt() || eType == EcorePackage.eINSTANCE.getEIntegerObject()) {
                return "Integer";
            }
            if (eType == EcorePackage.eINSTANCE.getELong() || eType == EcorePackage.eINSTANCE.getELongObject()) {
                return "Long";
            }
            if (eType == EcorePackage.eINSTANCE.getEDouble() || eType == EcorePackage.eINSTANCE.getEDoubleObject()) {
                return "Double";
            }
            if (eType == EcorePackage.eINSTANCE.getEBoolean() || eType == EcorePackage.eINSTANCE.getEBooleanObject()) {
                return "Boolean";
            }
            if (eType == EcorePackage.eINSTANCE.getEFloat() || eType == EcorePackage.eINSTANCE.getEFloatObject()) {
                return "Float";
            }
            if (eType == EcorePackage.eINSTANCE.getEDate()) {
                return "Date";
            }
            if (eType == EcorePackage.eINSTANCE.getEByteArray()) {
                return "byte[]";
            }
            if (eType.getInstanceClass() == DataHandler.class) {
                return "DataHandler";
            }
        } else if (eType instanceof EClass) {
            if (embedsReference) {
                return "S" + eType.getName();
            }
            return "Long";
        }
        return "S" + eType.getName();
    }

    private static String firstLetterUpperCase(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }
}

