/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import org.bimserver.shared.meta.SClass;
import org.bimserver.shared.meta.SField;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.utils.Licenser;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersGenerator.class);
    private final Map<Class<?>, String> generatedClasses = new HashMap();
    private final Map<String, String> generatedMessages = new HashMap<String, String>();

    public void generate(Class<?> serviceInterfaceClass, File protoFile, File descFile, boolean createBaseMessages, SService service, List<String> imports) {
        this.generateProtoFile(serviceInterfaceClass, protoFile, createBaseMessages, service, imports);
        this.generateProtocolBuffersObjects(protoFile, descFile, false);
    }

    private void generateProtocolBuffersObjects(File protoFile, File protoDestFile, boolean javaOut) {
        String[] folders;
        File destDir = new File("../GeneratedProtocolBuffersClient/generated");
        File protoDir = new File("../BimServerClientLib/src/org/bimserver/client/protocolbuffers/");
        File execFile = null;
        String execFileName = "protoc";
        String path = System.getenv("PATH");
        for (String folder : folders = path.split(File.pathSeparator)) {
            File file = new File(folder, execFileName);
            if (!file.isFile()) continue;
            execFile = file;
            break;
        }
        if (execFile == null) {
            execFile = new File("../BimServer/deploy/protoc.exe");
        }
        try {
            ProcessBuilder processBuilder = null;
            processBuilder = javaOut ? new ProcessBuilder(execFile.getAbsolutePath(), "-I=" + protoDir.getAbsolutePath(), "--java_out=" + destDir.getAbsolutePath(), "--descriptor_set_out=" + protoDestFile.getAbsolutePath(), protoFile.getAbsolutePath()) : new ProcessBuilder(execFile.getAbsolutePath(), "-I=" + protoDir.getAbsolutePath(), "--descriptor_set_out=" + protoDestFile.getAbsolutePath(), protoFile.getAbsolutePath());
            final Process exec = processBuilder.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = exec.getInputStream();
                    byte[] buffer = new byte[1024];
                    try {
                        int red = inputStream.read(buffer);
                        while (red != -1) {
                            System.out.print(new String(buffer, 0, red));
                            red = inputStream.read(buffer);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }, "Protocol Buffers Generator").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = exec.getErrorStream();
                    byte[] buffer = new byte[1024];
                    try {
                        int red = inputStream.read(buffer);
                        while (red != -1) {
                            System.err.print(new String(buffer, 0, red));
                            red = inputStream.read(buffer);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }, "Protocol Buffers Generator").start();
            exec.waitFor();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void generateServiceInterfaceImplementation(String name, File file, SService sService) {
        try {
            PrintWriter out = new PrintWriter(file);
            out.println("package org.bimserver.pb;\n");
            out.println(Licenser.getCommentedLicenseText((File)new File("license.txt")));
            out.println("import java.util.*;");
            out.println("import com.google.protobuf.*;");
            out.println("import org.bimserver.utils.*;");
            out.println("import org.bimserver.pb.ProtocolBuffersService.*;");
            out.println("import com.google.protobuf.BlockingRpcChannel;");
            out.println("import org.bimserver.pb.ProtocolBuffersService.ServiceInterface.BlockingInterface;");
            out.println("import com.googlecode.protobuf.socketrpc.SocketRpcController;");
            out.println("import com.googlecode.protobuf.socketrpc.RpcChannels;");
            out.println("import com.googlecode.protobuf.socketrpc.SocketRpcConnectionFactories;");
            out.println("import javax.mail.util.ByteArrayDataSource;");
            out.println("import javax.activation.DataHandler;");
            out.println();
            out.println("@SuppressWarnings(\"unused\")");
            out.println("public class " + name + " implements org.bimserver.shared.ServiceInterface {\n");
            out.println("\tprivate BlockingInterface service;\n");
            out.println("\tprivate SocketRpcController rpcController;\n");
            out.println("\tpublic ProtocolBuffersServiceInterfaceImplementation(String address, int port) {");
            out.println("\t\tBlockingRpcChannel rpcChannel = RpcChannels.newBlockingRpcChannel(SocketRpcConnectionFactories.createRpcConnectionFactory(address, port));");
            out.println("\t\trpcController = new SocketRpcController();");
            out.println("\t\tservice = ServiceInterface.newBlockingStub(rpcChannel);");
            out.println("\t}\n");
            for (SMethod sMethod : sService.getMethods()) {
                String fullResultType = "void";
                if (sMethod.returnsVoid()) {
                    out.print("\tpublic void " + sMethod.getName() + "(");
                } else {
                    fullResultType = sMethod.getReturnType().getName();
                    if (sMethod.isAggregateReturnType()) {
                        fullResultType = sMethod.getReturnType().getName() + "<" + sMethod.getGenericReturnType().getName() + ">";
                    }
                    out.print("\tpublic " + fullResultType + " " + sMethod.getName() + "(");
                }
                for (SParameter parameter : sMethod.getParameters()) {
                    if (parameter.isAggregate()) {
                        out.print(parameter.getType().getName() + "<" + parameter.getGenericType().getName() + "> " + parameter.getName() + (parameter.isLast() ? "" : ", "));
                        continue;
                    }
                    out.print(parameter.getType().getName() + " " + parameter.getName() + (parameter.isLast() ? "" : ", "));
                }
                out.println(") {");
                out.println("\t\ttry {");
                String requestClassName = StringUtils.firstUpperCase((String)sMethod.getName()) + "Request";
                String responseClassName = StringUtils.firstUpperCase((String)sMethod.getName()) + "Response";
                out.println("\t\t\t" + requestClassName + ".Builder requestBuilder = " + requestClassName + ".newBuilder();");
                for (SParameter parameter : sMethod.getParameters()) {
                    if (parameter.isAggregate()) {
                        out.println("\t\t\tfor (" + parameter.getGenericType() + " val : " + parameter.getName() + ") {");
                        if (parameter.getType().isPrimitive() || parameter.getType().getInstanceClass() == String.class) {
                            out.println("\t\t\t\t" + parameter.getGenericType().getInstanceClass().getSimpleName() + " v = val;");
                        } else {
                            out.println("\t\t\t\tProtocolBuffersService." + parameter.getGenericType().getInstanceClass().getSimpleName() + " v = null;");
                        }
                        out.println("\t\t\t\trequestBuilder.add" + StringUtils.firstUpperCase((String)parameter.getName()) + "(v);");
                        out.println("\t\t\t}");
                        continue;
                    }
                    if (parameter.getType().getInstanceClass().isAssignableFrom(DataHandler.class)) {
                        out.println("\t\t\tByteString bs = ByteString.copyFrom(BinUtils.readInputStream(" + parameter.getName() + ".getInputStream()));");
                        out.println("\t\t\trequestBuilder.set" + StringUtils.firstUpperCase((String)parameter.getName()) + "(bs);");
                        continue;
                    }
                    if (parameter.getType().getInstanceClass().isPrimitive()) {
                        out.println("\t\t\trequestBuilder.set" + StringUtils.firstUpperCase((String)parameter.getName()) + "(" + parameter.getName() + ");");
                        continue;
                    }
                    if (parameter.getType().getInstanceClass().isEnum()) {
                        out.println("\t\t\trequestBuilder.set" + StringUtils.firstUpperCase((String)parameter.getName()) + "(ProtocolBuffersService." + parameter.getType().getInstanceClass().getSimpleName() + ".values()[" + parameter.getName() + ".ordinal()]);");
                        continue;
                    }
                    if (parameter.getType().getInstanceClass().isPrimitive() || parameter.getType().getInstanceClass() == String.class) {
                        out.println("\t\t\trequestBuilder.set" + StringUtils.firstUpperCase((String)parameter.getName()) + "(" + parameter.getName() + ");");
                        continue;
                    }
                    out.println("\t\t\tProtocolBuffersService." + parameter.getType().getInstanceClass().getSimpleName() + ".Builder newVal = " + parameter.getType().getInstanceClass().getSimpleName() + ".newBuilder();");
                    this.genServiceInterfaceToProtocolBuffers(out, parameter.getName(), "newVal", parameter.getType());
                    out.println("\t\t\trequestBuilder.set" + StringUtils.firstUpperCase((String)parameter.getName()) + "(newVal.build());");
                }
                out.println("\t\t\t" + requestClassName + " request = requestBuilder.build();");
                if (sMethod.returnsVoid()) {
                    out.println("\t\t\tservice." + sMethod.getName() + "(rpcController, request);");
                } else {
                    String fullTypeName;
                    out.println("\t\t\t" + responseClassName + " response = service." + sMethod.getName() + "(rpcController, request);");
                    if (sMethod.isListReturnType()) {
                        out.println("\t\t\t" + fullResultType + " realResult = new ArrayList<" + sMethod.getGenericReturnType().getName() + ">();");
                        fullTypeName = sMethod.getGenericReturnType().getName();
                        if (!sMethod.getGenericReturnType().isPrimitive() && sMethod.getGenericReturnType().getInstanceClass() != String.class) {
                            fullTypeName = "ProtocolBuffersService." + sMethod.getGenericReturnType().getName();
                        }
                        out.println("\t\t\tList<" + fullTypeName + "> originalList = response.getValueList();");
                        out.println("\t\t\tfor (" + fullTypeName + " val : originalList) {");
                        if (sMethod.getGenericReturnType().getInstanceClass() == String.class) {
                            out.println("\t\t\t\trealResult.add(val);");
                        } else if (sMethod.getGenericReturnType().isEnum()) {
                            out.println("\t\t\t\trealResult.add(" + sMethod.getGenericReturnType().getName() + ".values()[val.ordinal()]);");
                        } else {
                            out.println("\t\t\t\t" + sMethod.getGenericReturnType().getName() + " v = " + this.genInitializerCode(sMethod.getGenericReturnType().getInstanceClass()) + ";");
                            this.genProtocolBuffersToServiceInterface(out, "val", "v", sMethod.getGenericReturnType(), sMethod);
                            out.println("\t\t\t\trealResult.add(v);");
                        }
                        out.println("\t\t\t}");
                        out.println("\t\treturn realResult;");
                    } else if (sMethod.getGenericReturnType().isSet()) {
                        out.println("\t\t\t" + fullResultType + " realResult = new HashSet<" + sMethod.getGenericReturnType().getName() + ">();");
                        fullTypeName = "";
                        if (!sMethod.getGenericReturnType().isPrimitive() && !sMethod.getGenericReturnType().isString()) {
                            fullTypeName = "ProtocolBuffersService." + sMethod.getGenericReturnType().getInstanceClass().getSimpleName();
                        }
                        out.println("\t\t\tList<" + fullTypeName + "> originalList = response.getValueList();");
                        out.println("\t\t\tfor (" + fullTypeName + " val : originalList) {");
                        if (sMethod.getGenericReturnType().isString()) {
                            out.println("\t\t\t\trealResult.add(val);");
                        } else if (sMethod.getGenericReturnType().isEnum()) {
                            out.println("\t\t\t\trealResult.add(" + sMethod.getGenericReturnType().getName() + ".values()[val.ordinal()]);");
                        } else {
                            out.println("\t\t\t\t" + sMethod.getGenericReturnType().getName() + " v = " + this.genInitializerCode(sMethod.getGenericReturnType().getInstanceClass()) + ";");
                            this.genProtocolBuffersToServiceInterface(out, "val", "v", sMethod.getGenericReturnType(), sMethod);
                            out.println("\t\t\t\trealResult.add(v);");
                        }
                        out.println("\t\t\t}");
                        out.println("\t\treturn realResult;");
                    } else if (sMethod.getReturnType().isPrimitive() || sMethod.getReturnType().isString()) {
                        out.println("\t\t\treturn response.getValue();");
                    } else if (sMethod.getReturnType().isDate()) {
                        out.println("\t\t\treturn new java.util.Date(response.getValue());");
                    } else if (sMethod.getGenericReturnType().isEnum()) {
                        out.println("\t\t\treturn null;");
                    } else {
                        out.println("\t\t\t" + sMethod.getGenericReturnType().getName() + " realResult = new " + sMethod.getReturnType().getName() + "();");
                        out.println("\t\t\tProtocolBuffersService." + sMethod.getReturnType().getName() + " val = response.getValue();");
                        this.genProtocolBuffersToServiceInterface(out, "val", "realResult", sMethod.getReturnType(), sMethod);
                        out.println("\t\t\treturn realResult;");
                    }
                }
                out.println("\t\t} catch (Exception e) {}");
                if (!sMethod.returnsVoid()) {
                    out.println("\t\treturn " + this.getDefaultLiteralCode(sMethod.getGenericReturnType().getInstanceClass()) + ";");
                }
                out.println("\t}\n");
            }
            out.println('}');
            out.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void genProtocolBuffersToServiceInterface(PrintWriter out, String sourceName, String targetName, SClass sType, SMethod method) {
        for (SField field : sType.getAllFields()) {
            if (sType.getInstanceClass().isAssignableFrom(List.class)) continue;
            if (sType.isDate()) {
                out.println("\t\t\t\t" + targetName + ".set" + field.getName() + "(new Date(" + sourceName + "." + method.getName() + "()));");
                continue;
            }
            if (sType.isClass()) {
                out.println("\t\t\t\t" + targetName + ".set" + field.getName() + "(Class.forName(" + sourceName + "." + method.getName() + "()));");
                continue;
            }
            if (sType.isDataHandler()) {
                out.println("\t\t\t\t" + targetName + ".setFile(new DataHandler(new ByteArrayDataSource(" + sourceName + ".getFile().toByteArray(), \"\")));");
                continue;
            }
            if (sType.isEnum()) {
                out.println("\t\t\t\t" + targetName + ".set" + field.getName() + "(" + method.getReturnType().getName().replace("$", ".") + ".values()[" + sourceName + "." + method.getName() + "().ordinal()]);");
                continue;
            }
            out.println("\t\t\t\t" + targetName + ".set" + field.getName() + "(" + sourceName + "." + method.getName() + "());");
        }
    }

    private void genServiceInterfaceToProtocolBuffers(PrintWriter out, String sourceName, String targetName, SClass parameterType) {
        for (SField field : parameterType.getAllFields()) {
            SClass fieldType = field.getType();
            SClass fieldClass = fieldType;
            if (fieldClass.isList()) {
                out.println("\t\t\tfor (" + fieldType.getName() + " o : " + sourceName + "." + field.getName() + "()) {");
                out.println("\t\t\t\t" + targetName + ".add" + field.getName() + "(o);");
                out.println("\t\t\t}");
                continue;
            }
            if (fieldClass.isDate()) {
                out.println("\t\t\t" + targetName + ".set" + field.getName() + "(" + sourceName + "." + field.getName() + "().getTime());");
                continue;
            }
            if (fieldType.getInstanceClass() == byte[].class) {
                out.println("\t\t\t" + targetName + ".set" + field.getName() + "(ByteString.copyFrom(" + sourceName + "." + field.getName() + "()));");
                continue;
            }
            if (fieldClass.isEnum()) {
                out.println("\t\t\t" + targetName + ".set" + field.getName() + "(" + fieldType.getInstanceClass().getSimpleName() + ".values()[" + sourceName + "." + field.getName() + "().ordinal()]);");
                continue;
            }
            out.println("\t\t\t" + targetName + ".set" + field.getName() + "(" + sourceName + "." + field.getName() + "());");
        }
    }

    private String genInitializerCode(Class<?> type) {
        if (type.isPrimitive()) {
            return this.getDefaultLiteralCode(type);
        }
        if (type == String.class) {
            return "\"\"";
        }
        if (type.isEnum()) {
            return "null";
        }
        return "new " + type.getName() + "()";
    }

    private String getDefaultLiteralCode(Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "false";
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return "0";
        }
        if (type == Long.class || type == Long.TYPE) {
            return "0L";
        }
        if (type.isEnum()) {
            return "null";
        }
        return "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProtoFile(Class<?> serviceInterfaceClass, File protoFile, boolean createBaseMessages, SService service, List<String> imports) {
        try (PrintWriter out = null;){
            out = new PrintWriter(protoFile);
            out.println("package org.bimserver.pb;\n");
            out.println(Licenser.getCommentedLicenseText((File)new File("license.txt")));
            for (String importFile : imports) {
                out.println("import \"" + importFile + ".proto\";");
            }
            out.println("option java_generic_services = true;\n");
            out.println("option java_outer_classname = \"" + service.getSimpleName() + "Impl\";\n");
            out.println("option optimize_for = SPEED;\n");
            StringBuilder serviceBuilder = new StringBuilder();
            StringBuilder messageBuilder = new StringBuilder();
            serviceBuilder.append("service " + service.getSimpleName() + " {\n");
            if (createBaseMessages) {
                this.createVoidResponseMessage(messageBuilder);
                this.generateVoidMessage(messageBuilder);
            }
            for (SMethod method : service.getMethods()) {
                String inputObjectName = StringUtils.firstUpperCase((String)method.getName()) + "Request";
                String outputObjectName = StringUtils.firstUpperCase((String)method.getName()) + "Response";
                this.createRequestMessage(messageBuilder, method, inputObjectName);
                if (method.returnsVoid()) {
                    outputObjectName = "VoidResponse";
                } else {
                    this.createResponseMessage(messageBuilder, method, outputObjectName);
                }
                serviceBuilder.append("\trpc " + method.getName() + " (" + inputObjectName + ") returns (" + outputObjectName + ");\n\n");
            }
            serviceBuilder.append("}\n\n");
            out.print(serviceBuilder.toString());
            out.print(messageBuilder.toString());
        }
    }

    private void generateVoidMessage(StringBuilder builder) {
        builder.append("message Void {\n}");
    }

    private void createVoidResponseMessage(StringBuilder builder) {
        String messageName = "VoidResponse";
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("message " + messageName + " {\n");
        messageBuilder.append("\toptional string errorMessage = 1;\n");
        messageBuilder.append("}\n\n");
        builder.append((CharSequence)messageBuilder);
    }

    private void createResponseMessage(StringBuilder builder, SMethod method, String messageName) {
        if (this.generatedMessages.containsKey(messageName)) {
            return;
        }
        this.generatedMessages.put(messageName, messageName);
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("message " + messageName + " {\n");
        messageBuilder.append("\toptional string errorMessage = 1;\n");
        messageBuilder.append('\t');
        if (method.isAggregateReturnType()) {
            messageBuilder.append("repeated ");
        } else {
            messageBuilder.append("optional ");
        }
        messageBuilder.append(this.createMessage(builder, method.isAggregateReturnType() ? method.getGenericReturnType() : method.getReturnType()) + " value = 2;\n");
        messageBuilder.append("}\n\n");
        builder.append((CharSequence)messageBuilder);
    }

    private String createMessage(StringBuilder sb, SClass sType) {
        if (sType == null) {
            return "VoidResponse";
        }
        Class clazz = sType.getInstanceClass();
        if (this.generatedClasses.containsKey(clazz)) {
            return this.generatedClasses.get(clazz);
        }
        if (clazz == Class.class) {
            return "string";
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return "bool";
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return "int64";
        }
        if (clazz == Date.class) {
            return "int64";
        }
        if (clazz == DataHandler.class || clazz == byte[].class || clazz == Byte[].class) {
            return "bytes";
        }
        if (clazz == Integer.class | clazz == Integer.TYPE) {
            return "int32";
        }
        if (clazz == Float.class | clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Double.class | clazz == Double.TYPE) {
            return "double";
        }
        if (clazz.isEnum()) {
            return this.createEnum(sb, clazz);
        }
        if (sType.isString()) {
            return "string";
        }
        StringBuilder messageBuilder = new StringBuilder();
        this.generatedClasses.put(clazz, clazz.getSimpleName());
        messageBuilder.append("message " + clazz.getSimpleName() + " {\n");
        int counter = 1;
        if (!sType.getSubClasses().isEmpty()) {
            messageBuilder.append("\trequired string __actual_type = " + counter++ + ";\n");
            for (SClass subClass : sType.getSubClasses()) {
                messageBuilder.append('\t');
                messageBuilder.append("optional ");
                messageBuilder.append(this.createMessage(sb, subClass) + " __" + subClass.getInstanceClass().getSimpleName() + " = " + counter++ + ";\n");
            }
        }
        for (SField field : sType.getAllFields()) {
            messageBuilder.append('\t');
            if (field.isAggregate()) {
                messageBuilder.append("repeated ");
            } else {
                messageBuilder.append("optional ");
            }
            SClass type = field.getType();
            if (field.isAggregate()) {
                type = field.getGenericType();
            }
            messageBuilder.append(this.createMessage(sb, type) + " " + field.getName() + " = " + counter++ + ";\n");
        }
        messageBuilder.append("}\n\n");
        sb.append((CharSequence)messageBuilder);
        return clazz.getSimpleName();
    }

    private String createEnum(StringBuilder sb, Class<?> clazz) {
        if (this.generatedClasses.containsKey(clazz)) {
            return this.generatedClasses.get(clazz);
        }
        this.generatedClasses.put(clazz, clazz.getSimpleName());
        sb.append("enum " + clazz.getSimpleName() + "{\n");
        int counter = 0;
        for (Object o : clazz.getEnumConstants()) {
            sb.append("\t" + clazz.getSimpleName() + "_" + o.toString() + " = " + counter++ + ";\n");
        }
        sb.append("}\n\n");
        return clazz.getSimpleName();
    }

    private void createRequestMessage(StringBuilder builder, SMethod method, String messageName) {
        if (this.generatedMessages.containsKey(messageName)) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        this.generatedMessages.put(messageName, messageName);
        messageBuilder.append("message " + messageName + " {\n");
        int counter = 1;
        for (SParameter sParameter : method.getParameters()) {
            messageBuilder.append('\t');
            if (sParameter.isAggregate()) {
                messageBuilder.append("repeated ");
            } else {
                messageBuilder.append("optional ");
            }
            messageBuilder.append(this.createMessage(builder, sParameter.getBestType()) + " " + sParameter.getName() + " = " + counter++ + ";\n");
        }
        messageBuilder.append("}\n\n");
        builder.append((CharSequence)messageBuilder);
    }
}

