/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.tools.generators.SConverterGenerator;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SConverterGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SConverterGeneratorWrapper.class);
    private File sourceFolder = new File("../BimServer/generated");
    private File packageFolder = new File(this.sourceFolder, "org" + File.separator + "bimserver" + File.separator + "interfaces");
    private final MetaDataManager metaDataManager;

    public SConverterGeneratorWrapper(MetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public void generate(Set<EPackage> ePackages) {
        try {
            FileUtils.forceMkdir((File)this.packageFolder);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        SConverterGenerator converterGenerator = new SConverterGenerator();
        Object[] arguments = new Object[]{this.metaDataManager, ePackages};
        String generated = converterGenerator.generate(arguments);
        File file = new File(this.packageFolder, "SConverter.java");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(generated.getBytes(Charsets.UTF_8));
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

