/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.webservices.LongTransaction;
import org.bimserver.webservices.NoTransactionException;

public class LongTransactionManager {
    private final AtomicLong counter = new AtomicLong();
    private final Map<Long, LongTransaction> runningTransactions = new HashMap<Long, LongTransaction>();

    public synchronized LongTransaction newLongTransaction(PackageMetaData packageMetaData, long poid, int pid, int rid, long roid) {
        LongTransaction longTransaction = new LongTransaction(packageMetaData, poid, roid, pid, rid, this.counter.incrementAndGet());
        this.runningTransactions.put(longTransaction.getTid(), longTransaction);
        return longTransaction;
    }

    public LongTransaction get(Long tid) throws NoTransactionException {
        LongTransaction longTransaction = this.runningTransactions.get(tid);
        if (longTransaction == null) {
            throw new NoTransactionException("No transaction with tid " + tid + " could be found");
        }
        return longTransaction;
    }

    public void remove(long tid) throws NoTransactionException {
        this.get(tid);
        this.runningTransactions.remove(tid);
    }
}

