/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices;

import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.User;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.AnonymousAuthorization;
import org.bimserver.webservices.authorization.Authorization;

public class PublicInterfaceFactory
implements ServiceFactory {
    private final BimServer bimServer;

    public PublicInterfaceFactory(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public ServiceMap get(Authorization authorization, AccessMethod accessMethod) {
        ServiceMap serviceMap = new ServiceMap(this.bimServer, authorization, accessMethod);
        return serviceMap;
    }

    public synchronized ServiceMap get(AccessMethod accessMethod) throws UserException {
        AnonymousAuthorization authorization = new AnonymousAuthorization(this.bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
        return this.get(authorization, accessMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ServiceMap get(String token, AccessMethod accessMethod) throws UserException {
        try {
            Authorization authorization = Authorization.fromToken(this.bimServer.getEncryptionKey(), token);
            try (DatabaseSession session = this.bimServer.getDatabase().createSession();){
                User user = (User)session.get(authorization.getUoid(), OldQuery.getDefault());
                if (user == null) {
                    throw new UserException("No user found with uoid " + authorization.getUoid());
                }
                if (user.getState() == ObjectState.DELETED) {
                    throw new UserException("User has been deleted");
                }
            }
            return this.get(authorization, accessMethod);
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                throw (UserException)((Object)e);
            }
            throw new UserException((Throwable)e);
        }
    }
}

