/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.ServiceHolder;
import org.bimserver.shared.ServiceMapInterface;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.interfaces.async.AsyncAdminInterface;
import org.bimserver.shared.interfaces.async.AsyncAuthInterface;
import org.bimserver.shared.interfaces.async.AsyncBimsie1LowLevelInterface;
import org.bimserver.shared.interfaces.async.AsyncMetaInterface;
import org.bimserver.shared.interfaces.async.AsyncPluginInterface;
import org.bimserver.shared.interfaces.async.AsyncRegistryInterface;
import org.bimserver.shared.interfaces.async.AsyncServiceInterface;
import org.bimserver.shared.interfaces.async.AsyncSettingsInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1AuthInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1LowLevelInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1NotificationInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1NotificationRegistryInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1ServiceInterface;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.impl.AdminServiceImpl;
import org.bimserver.webservices.impl.AuthServiceImpl;
import org.bimserver.webservices.impl.Bimsie1AuthServiceImpl;
import org.bimserver.webservices.impl.Bimsie1LowLevelServiceImpl;
import org.bimserver.webservices.impl.Bimsie1NotificationImpl;
import org.bimserver.webservices.impl.Bimsie1NotificationRegistryServiceImpl;
import org.bimserver.webservices.impl.Bimsie1RemoteServiceImpl;
import org.bimserver.webservices.impl.Bimsie1ServiceImpl;
import org.bimserver.webservices.impl.MetaServiceImpl;
import org.bimserver.webservices.impl.PluginServiceImpl;
import org.bimserver.webservices.impl.ServiceImpl;
import org.bimserver.webservices.impl.SettingsServiceImpl;

public class ServiceMap
implements ServiceMapInterface,
ServiceHolder {
    private BimServer bimServer;
    private AccessMethod accessMethod;
    private Authorization authorization;
    private final Map<Class<? extends PublicInterface>, PublicInterface> interfaces = new HashMap<Class<? extends PublicInterface>, PublicInterface>();

    public ServiceMap(BimServer bimServer, Authorization authorization, AccessMethod accessMethod) {
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.accessMethod = accessMethod;
    }

    public void put(Class<PublicInterface> clazz, PublicInterface publicInterface) {
        this.interfaces.put(clazz, publicInterface);
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public <T extends PublicInterface> T get(Class<T> clazz) {
        Object publicInterface = this.interfaces.get(clazz);
        if (publicInterface != null) {
            return (T)publicInterface;
        }
        if (clazz == ServiceInterface.class) {
            publicInterface = new ServiceImpl(this);
        } else if (clazz == Bimsie1AuthInterface.class) {
            publicInterface = new Bimsie1AuthServiceImpl(this);
        } else if (clazz == AuthInterface.class) {
            publicInterface = new AuthServiceImpl(this);
        } else if (clazz == AdminInterface.class) {
            publicInterface = new AdminServiceImpl(this);
        } else if (clazz == Bimsie1LowLevelInterface.class) {
            publicInterface = new Bimsie1LowLevelServiceImpl(this);
        } else if (clazz == MetaInterface.class) {
            publicInterface = new MetaServiceImpl(this);
        } else if (clazz == SettingsInterface.class) {
            publicInterface = new SettingsServiceImpl(this);
        } else if (clazz == Bimsie1RemoteServiceInterface.class) {
            publicInterface = new Bimsie1RemoteServiceImpl(this.bimServer, this);
        } else if (clazz == Bimsie1NotificationInterface.class) {
            publicInterface = new Bimsie1NotificationImpl(this.bimServer);
        } else if (clazz == Bimsie1NotificationRegistryInterface.class) {
            publicInterface = new Bimsie1NotificationRegistryServiceImpl(this);
        } else if (clazz == Bimsie1ServiceInterface.class) {
            publicInterface = new Bimsie1ServiceImpl(this);
        } else if (clazz == PluginInterface.class) {
            publicInterface = new PluginServiceImpl(this);
        } else {
            throw new RuntimeException("Unknown interface: " + clazz.getName());
        }
        this.interfaces.put((Class<? extends PublicInterface>)clazz, (PublicInterface)publicInterface);
        return (T)publicInterface;
    }

    public <T extends PublicInterface> void add(Class<T> class1, T remoteServiceInterface) {
        this.interfaces.put(class1, remoteServiceInterface);
    }

    public AsyncAdminInterface getAdminAsync() {
        return new AsyncAdminInterface(this.get(AdminInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncBimsie1LowLevelInterface getBimsie1LowLevelAsync() {
        return new AsyncBimsie1LowLevelInterface(this.get(Bimsie1LowLevelInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncMetaInterface getMetaAsync() {
        return new AsyncMetaInterface(this.get(MetaInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncPluginInterface getPluginAsync() {
        return new AsyncPluginInterface(this.get(PluginInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncRegistryInterface getRegistryAsync() {
        return new AsyncRegistryInterface(this.get(Bimsie1NotificationRegistryInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncServiceInterface getServiceAsync() {
        return new AsyncServiceInterface(this.get(ServiceInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncAuthInterface getAuthInterfaceAsync() {
        return new AsyncAuthInterface(this.get(AuthInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncSettingsInterface getSettingsAsync() {
        return new AsyncSettingsInterface(this.get(SettingsInterface.class), this.bimServer.getExecutorService());
    }

    public AdminInterface getAdminInterface() throws PublicInterfaceNotFoundException {
        return this.get(AdminInterface.class);
    }

    public Bimsie1AuthInterface getBimsie1AuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(Bimsie1AuthInterface.class);
    }

    public Bimsie1LowLevelInterface getBimsie1LowLevelInterface() throws PublicInterfaceNotFoundException {
        return this.get(Bimsie1LowLevelInterface.class);
    }

    public AuthInterface getAuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(AuthInterface.class);
    }

    public MetaInterface getMeta() throws PublicInterfaceNotFoundException {
        return this.get(MetaInterface.class);
    }

    public PluginInterface getPluginInterface() {
        return this.get(PluginInterface.class);
    }

    public Bimsie1NotificationRegistryInterface getRegistry() throws PublicInterfaceNotFoundException {
        return this.get(Bimsie1NotificationRegistryInterface.class);
    }

    public ServiceInterface getServiceInterface() throws PublicInterfaceNotFoundException {
        return this.get(ServiceInterface.class);
    }

    public SettingsInterface getSettingsInterface() throws PublicInterfaceNotFoundException {
        return this.get(SettingsInterface.class);
    }

    public AuthInterface getBimServerAuthInterface() {
        return this.get(AuthInterface.class);
    }

    public Bimsie1ServiceInterface getBimsie1ServiceInterface() {
        return this.get(Bimsie1ServiceInterface.class);
    }
}

