/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.authorization;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.AnonymousAuthorization;
import org.bimserver.webservices.authorization.AuthenticationException;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.bimserver.webservices.authorization.UserAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Authorization {
    private static final Logger LOGGER = LoggerFactory.getLogger(Authorization.class);
    private final GregorianCalendar expires = new GregorianCalendar();
    private long uoid = -1L;

    public Authorization(int expires, TimeUnit expiresUnit) {
        this.expires.add(13, (int)TimeUnit.SECONDS.convert(expires, expiresUnit));
    }

    public Authorization() {
    }

    public GregorianCalendar getExpires() {
        return this.expires;
    }

    public void canDownload(long roid) throws UserException {
    }

    public void canCheckin(long poid) throws UserException {
    }

    public void canReadExtendedData(long roid) throws UserException {
    }

    public void canWriteExtendedData(long roid) throws UserException {
    }

    protected abstract int getBufferSize();

    protected abstract byte getId();

    public boolean hasRightsOnProjectOrSuperProjectsOrSubProjects(User user, Project project) {
        if (user == null) {
            return false;
        }
        if (user.getUserType() == UserType.ADMIN || user.getUserType() == UserType.SYSTEM) {
            return true;
        }
        while (project != null) {
            if (this.hasRightsOnProjectOrSubProjects(user, project)) {
                return true;
            }
            project = project.getParent();
        }
        return false;
    }

    public boolean hasRightsOnProjectOrSuperProjects(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN || user.getUserType() == UserType.SYSTEM) {
            return true;
        }
        if (this.hasRightsOnProject(user, project)) {
            return true;
        }
        return project.getParent() != null && this.hasRightsOnProjectOrSuperProjects(user, project.getParent());
    }

    public boolean hasRightsOnProjectOrSubProjects(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN || user.getUserType() == UserType.SYSTEM) {
            return true;
        }
        if (this.hasRightsOnProject(user, project)) {
            return true;
        }
        for (Project subProject : project.getSubProjects()) {
            if (!this.hasRightsOnProjectOrSubProjects(user, subProject)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRightsOnProject(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN || user.getUserType() == UserType.SYSTEM) {
            return true;
        }
        for (User authorizedUser : project.getHasAuthorizedUsers()) {
            if (authorizedUser != user) continue;
            return true;
        }
        return false;
    }

    protected abstract void getBytes(ByteBuffer var1);

    public String asHexToken(Key key) {
        try {
            Cipher encodingCipher = Cipher.getInstance("AES");
            encodingCipher.init(1, key);
            ByteBuffer buffer = ByteBuffer.allocate(33 + this.getBufferSize());
            buffer.position(16);
            buffer.put(this.getId());
            buffer.putLong(this.getExpires().getTimeInMillis());
            buffer.putLong(this.getUoid());
            this.getBytes(buffer);
            if (buffer.position() != buffer.capacity()) {
                throw new RuntimeException("Buffer's position should be at the end " + buffer.position() + "/" + buffer.capacity());
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            buffer.position(16);
            messageDigest.update(buffer);
            buffer.position(0);
            buffer.put(messageDigest.digest());
            byte[] encodedBytes = encodingCipher.doFinal(buffer.array());
            String encodedHexString = new String(Hex.encodeHex((byte[])encodedBytes));
            return encodedHexString;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static Authorization fromToken(SecretKeySpec key, String token) throws AuthenticationException {
        if (token == null) {
            throw new IllegalArgumentException("Token required");
        }
        try {
            int hashSizeBytes = 16;
            Cipher decodingCipher = Cipher.getInstance("AES");
            decodingCipher.init(2, key);
            ByteBuffer buffer = ByteBuffer.wrap(decodingCipher.doFinal(Hex.decodeHex((char[])token.toCharArray())));
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] foundHash = new byte[hashSizeBytes];
            buffer.get(foundHash, 0, hashSizeBytes);
            byte[] hashInput = new byte[buffer.capacity() - hashSizeBytes];
            buffer.get(hashInput);
            buffer.position(hashSizeBytes);
            byte[] calculatedHash = messageDigest.digest(hashInput);
            if (Arrays.equals(foundHash, calculatedHash)) {
                byte type = buffer.get();
                Authorization authorization = null;
                long expires = buffer.getLong();
                long uoid = buffer.getLong();
                switch (type) {
                    case 2: {
                        authorization = ExplicitRightsAuthorization.fromBuffer(buffer);
                        break;
                    }
                    case 4: {
                        authorization = UserAuthorization.fromBuffer(buffer);
                        break;
                    }
                    case 3: {
                        authorization = SystemAuthorization.fromBuffer(buffer);
                        break;
                    }
                    case 1: {
                        authorization = AnonymousAuthorization.fromBuffer(buffer);
                        break;
                    }
                    case 5: {
                        authorization = AdminAuthorization.fromBuffer(buffer);
                        break;
                    }
                    default: {
                        throw new AuthenticationException("Unknown authorization type: " + type);
                    }
                }
                authorization.setUoid(uoid);
                authorization.setExpires(expires);
                if (authorization.getExpires().getTimeInMillis() < new GregorianCalendar().getTimeInMillis()) {
                    throw new AuthenticationException("This token has expired");
                }
                return authorization;
            }
            throw new AuthenticationException("Given token is corrupt");
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationException("Invalid token", e);
        }
        catch (DecoderException e) {
            throw new AuthenticationException((Exception)((Object)e));
        }
    }

    private void setExpires(long expires) {
        this.expires.setTimeInMillis(expires);
    }

    public long getUoid() {
        return this.uoid;
    }

    public void setUoid(long uoid) {
        this.uoid = uoid;
    }
}

