/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.authorization;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class ExplicitRightsAuthorization
extends Authorization {
    public static final byte ID = 2;
    private long[] readRevisionRoids;
    private long writeProjectPoid = -1L;
    private long readExtendedDataRoid = -1L;
    private long writeExtendedDataRoid = -1L;
    private long soid;

    public ExplicitRightsAuthorization(BimServer bimServer, long uoid, long soid, long[] readRevisionRoids, long writeProjectPoid, long readExtendedDataRoid, long writeExtendedDataRoid) {
        super(bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
        this.soid = soid;
        this.setUoid(uoid);
        this.setReadRevisionRoids(readRevisionRoids);
        this.setWriteProjectPoid(writeProjectPoid);
        this.setReadExtendedDataRoid(readExtendedDataRoid);
        this.setWriteExtendedDataRoid(writeExtendedDataRoid);
    }

    private ExplicitRightsAuthorization() {
    }

    public long getSoid() {
        return this.soid;
    }

    @Override
    public void canDownload(long roid) throws UserException {
        for (long rroid : this.getReadRevisionRoids()) {
            if (rroid != roid) continue;
            return;
        }
        throw new UserException("No rights to download revision");
    }

    @Override
    public void canCheckin(long poid) throws UserException {
        if (this.getWriteProjectPoid() != poid) {
            throw new UserException("No rights to checkin to this project");
        }
    }

    @Override
    public void canReadExtendedData(long roid) throws UserException {
        if (this.getReadExtendedDataRoid() != roid) {
            throw new UserException("No rights to read extended data from revision");
        }
    }

    @Override
    public void canWriteExtendedData(long roid) throws UserException {
        if (this.getWriteExtendedDataRoid() != roid) {
            throw new UserException("No rights to write extended data to revision");
        }
    }

    public static ExplicitRightsAuthorization fromBuffer(ByteBuffer buffer) {
        ExplicitRightsAuthorization explicitRightsAuthorization = new ExplicitRightsAuthorization();
        explicitRightsAuthorization.setUoid(buffer.getLong());
        explicitRightsAuthorization.setSoid(buffer.getLong());
        int nrRoids = buffer.getInt();
        long[] roids = new long[nrRoids];
        for (int i = 0; i < nrRoids; ++i) {
            roids[i] = buffer.getLong();
        }
        explicitRightsAuthorization.setReadRevisionRoids(roids);
        explicitRightsAuthorization.setWriteProjectPoid(buffer.getLong());
        explicitRightsAuthorization.setReadExtendedDataRoid(buffer.getLong());
        explicitRightsAuthorization.setWriteExtendedDataRoid(buffer.getLong());
        return explicitRightsAuthorization;
    }

    private void setSoid(long soid) {
        this.soid = soid;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    protected int getBufferSize() {
        return 44 + this.getReadRevisionRoids().length * 8;
    }

    @Override
    public void getBytes(ByteBuffer buffer) {
        buffer.putLong(this.getUoid());
        buffer.putLong(this.getSoid());
        buffer.putInt(this.getReadRevisionRoids().length);
        for (long roid : this.getReadRevisionRoids()) {
            buffer.putLong(roid);
        }
        buffer.putLong(this.getWriteProjectPoid());
        buffer.putLong(this.getReadExtendedDataRoid());
        buffer.putLong(this.getWriteExtendedDataRoid());
    }

    public long[] getReadRevisionRoids() {
        return this.readRevisionRoids;
    }

    public void setReadRevisionRoids(long[] readRevisionRoids) {
        this.readRevisionRoids = readRevisionRoids;
    }

    public long getWriteProjectPoid() {
        return this.writeProjectPoid;
    }

    public void setWriteProjectPoid(long writeProjectPoid) {
        this.writeProjectPoid = writeProjectPoid;
    }

    public long getReadExtendedDataRoid() {
        return this.readExtendedDataRoid;
    }

    public void setReadExtendedDataRoid(long readExtendedDataRoid) {
        this.readExtendedDataRoid = readExtendedDataRoid;
    }

    public long getWriteExtendedDataRoid() {
        return this.writeExtendedDataRoid;
    }

    public void setWriteExtendedDataRoid(long writeExtendedDataRoid) {
        this.writeExtendedDataRoid = writeExtendedDataRoid;
    }
}

