/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ChangePasswordDatabaseAction;
import org.bimserver.database.actions.RequestPasswordChangeDatabaseAction;
import org.bimserver.database.actions.ValidateUserDatabaseAction;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class AuthServiceImpl
extends GenericServiceImpl
implements AuthInterface {
    public AuthServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public SUser getLoggedInUser() throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        return this.getServiceMap().get(ServiceInterface.class).getUserByUoid(Long.valueOf(this.getAuthorization().getUoid()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean changePassword(Long uoid, String oldPassword, String newPassword) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ChangePasswordDatabaseAction action = new ChangePasswordDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), uoid, oldPassword, newPassword, this.getAuthorization());
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPasswordChange(String username, String resetUrl) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RequestPasswordChangeDatabaseAction action = new RequestPasswordChangeDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer(), username, resetUrl);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser validateAccount(Long uoid, String token, String password) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ValidateUserDatabaseAction action = new ValidateUserDatabaseAction(session, this.getInternalAccessMethod(), uoid, token, password);
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sUser;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHash(Long uoid, byte[] hash, byte[] salt) throws ServerException, UserException {
        this.requireAdminAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(uoid, OldQuery.getDefault());
            user.setPasswordHash(hash);
            user.setPasswordSalt(salt);
            session.commit();
        }
    }
}

