/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.LoginDatabaseAction;
import org.bimserver.database.actions.LoginUserTokenDatabaseAction;
import org.bimserver.interfaces.objects.SAccessMethod;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1AuthInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class Bimsie1AuthServiceImpl
extends GenericServiceImpl
implements Bimsie1AuthInterface {
    public Bimsie1AuthServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login(String username, String password) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LoginDatabaseAction loginDatabaseAction = new LoginDatabaseAction(this.getBimServer(), session, this.getServiceMap(), super.getInternalAccessMethod(), username, password);
            String string = session.executeAndCommitAction(loginDatabaseAction);
            return string;
        }
    }

    public void logout() throws UserException {
        this.requireAuthenticationAndRunningServer();
        this.setAuthorization(null);
    }

    public Boolean isLoggedIn() {
        return this.getAuthorization() != null;
    }

    public SAccessMethod getAccessMethod() {
        return SAccessMethod.valueOf((String)this.getInternalAccessMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loginUserToken(String token) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LoginUserTokenDatabaseAction loginDatabaseAction = new LoginUserTokenDatabaseAction(this.getBimServer(), session, this.getServiceMap(), super.getInternalAccessMethod(), token);
            String string = session.executeAndCommitAction(loginDatabaseAction);
            return string;
        }
    }
}

